<?php
require_once '../config/config.php';

// Check if user is logged in
$user = new User();
if (!$user->isLoggedIn() || $user->getRole() !== 'user') {
    header('Location: ../index.php');
    exit;
}

// Get user data
$userId = $user->getId();
$userData = $user->getCurrentUser();

// Get user's tickets
$db = Database::getInstance();
$connection = $db->getConnection();

$sql = "SELECT t.*, 
        (SELECT COUNT(*) FROM ticket_messages WHERE ticket_id = t.id) as message_count 
        FROM support_tickets t 
        WHERE t.user_id = ? 
        ORDER BY t.updated_at DESC";
$stmt = $connection->prepare($sql);
$stmt->bind_param("i", $userId);
$stmt->execute();
$tickets = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);

// Include header
// include_once '../includes/header.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Support - Zealmart</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <style>
        body { background: #e5e5e5; }
        .sidebar {
            min-height: 100vh;
            background: linear-gradient(180deg, #3a86ff 0%, #8338ec 100%);
            padding-top: 20px;
            border-top-right-radius: 20px;
            border-bottom-right-radius: 20px;
            box-shadow: 2px 0 12px rgba(51,51,51,0.08);
            transition: background 0.3s;
        }
        .sidebar .sidebar-brand {
            display: flex;
            flex-direction: column;
            align-items: center;
            margin-bottom: 2rem;
        }
        .sidebar .sidebar-logo {
            width: 60px;
            height: 60px;
            border-radius: 50%;
            background: #fff;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-bottom: 0.5rem;
            box-shadow: 0 2px 8px rgba(0,0,0,0.08);
        }
        .sidebar .sidebar-logo i {
            font-size: 2rem;
            color: #3a86ff;
        }
        .sidebar .sidebar-title {
            color: #fff;
            font-weight: bold;
            font-size: 1.2rem;
            letter-spacing: 1px;
        }
        .sidebar-section {
            color: #e0e1dd;
            font-size: 0.85rem;
            text-transform: uppercase;
            margin: 1.5rem 0 0.5rem 1rem;
            letter-spacing: 0.08em;
        }
        .sidebar a {
            color: #fff;
            padding: 12px 22px;
            display: flex;
            align-items: center;
            border-radius: 8px 0 0 8px;
            margin-bottom: 6px;
            font-size: 1.05rem;
            transition: background 0.2s, color 0.2s, box-shadow 0.2s;
        }
        .sidebar a.active, .sidebar a:hover {
            background: rgba(255, 255, 255, 0.15);
            color: #ffbe0b;
            box-shadow: 2px 2px 8px rgba(0,0,0,0.07);
            font-weight: bold;
        }
        .sidebar a i {
            margin-right: 12px;
            font-size: 1.2em;
        }
        @media (max-width: 767.98px) {
            .sidebar {
                position: fixed;
                z-index: 1050;
                left: 0;
                top: 0;
                width: 220px;
                height: 100vh;
                transform: translateX(-100%);
                transition: transform 0.3s ease;
                border-radius: 0 20px 20px 0;
            }
            .sidebar.collapse.show {
                transform: translateX(0);
            }
            .main-content {
                padding: 10px;
            }
        }
        .main-content {
            background: #fff;
            min-height: 100vh;
            padding: 2rem 2rem 2rem 2rem;
        }
    </style>
</head>
<body>
<div class="container-fluid">
    <div class="row">
        <!-- Sidebar Overlay (for mobile) -->
        <div id="sidebarOverlay" style="display:none;position:fixed;top:0;left:0;width:100vw;height:100vh;background:rgba(0,0,0,0.3);z-index:1049;"></div>
        <!-- Sidebar Toggle Button (visible on mobile) -->
        <button class="btn btn-dark d-md-none m-2" type="button" data-toggle="collapse" data-target="#userSidebar" aria-controls="userSidebar" aria-expanded="false" aria-label="Toggle navigation">
            <i class="fas fa-bars"></i> Menu
        </button>
        <?php include_once '../includes/user_sidebar.php'; ?>
        <main class="col-md-10 ml-sm-auto main-content">
            <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                <h1 class="h2">Support Tickets</h1>
                <div class="btn-toolbar mb-2 mb-md-0">
                    <button type="button" class="btn btn-sm btn-primary" data-toggle="modal" data-target="#createTicketModal">
                        <i class="fas fa-plus"></i> Create New Ticket
                    </button>
                </div>
            </div>

            <!-- Tickets List -->
            <div class="table-responsive">
                <table class="table table-striped table-hover">
                    <thead>
                        <tr>
                            <th>Ticket ID</th>
                            <th>Subject</th>
                            <th>Status</th>
                            <th>Messages</th>
                            <th>Created</th>
                            <th>Last Updated</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (empty($tickets)): ?>
                        <tr>
                            <td colspan="7" class="text-center">No support tickets found</td>
                        </tr>
                        <?php else: ?>
                        <?php foreach ($tickets as $ticket): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($ticket['ticket_id']); ?></td>
                            <td><?php echo htmlspecialchars($ticket['subject']); ?></td>
                            <td>
                                <span class="badge bg-<?php 
                                    echo match($ticket['status']) {
                                        'created' => 'secondary',
                                        'active' => 'primary',
                                        'in_process' => 'info',
                                        'closed' => 'success',
                                        'inactive' => 'warning',
                                        'deleted' => 'danger',
                                        default => 'secondary'
                                    };
                                ?>">
                                    <?php echo ucfirst(str_replace('_', ' ', $ticket['status'])); ?>
                                </span>
                            </td>
                            <td><?php echo $ticket['message_count']; ?></td>
                            <td><?php echo date('Y-m-d H:i', strtotime($ticket['created_at'])); ?></td>
                            <td><?php echo date('Y-m-d H:i', strtotime($ticket['updated_at'])); ?></td>
                            <td>
                                <button type="button" class="btn btn-sm btn-info view-ticket" 
                                        data-ticket-id="<?php echo $ticket['id']; ?>"
                                        data-toggle="modal" data-target="#viewTicketModal">
                                    <i class="fas fa-eye"></i>
                                </button>
                                <?php if ($ticket['status'] !== 'closed' && $ticket['status'] !== 'deleted'): ?>
                                <button type="button" class="btn btn-sm btn-success reply-ticket"
                                        data-ticket-id="<?php echo $ticket['id']; ?>"
                                        data-toggle="modal" data-target="#replyTicketModal">
                                    <i class="fas fa-reply"></i>
                                </button>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </main>
    </div>
</div>

<!-- Create Ticket Modal -->
<div class="modal fade" id="createTicketModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Create Support Ticket</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>
            <div class="modal-body">
                <form id="createTicketForm">
                    <div class="mb-3">
                        <label for="subject" class="form-label">Subject</label>
                        <select class="form-select" id="subject" name="subject" required>
                            <option value="">Select Subject</option>
                            <option value="Account Issue">Account Issue</option>
                            <option value="PIN Issue">PIN Issue</option>
                            <option value="Payment Issue">Payment Issue</option>
                            <option value="Technical Support">Technical Support</option>
                            <option value="Other">Other</option>
                        </select>
                    </div>
                    
                    <div class="mb-3">
                        <label for="message" class="form-label">Message</label>
                        <textarea class="form-control" id="message" name="message" rows="5" required></textarea>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-primary" id="submitTicket">Submit Ticket</button>
            </div>
        </div>
    </div>
</div>

<!-- View Ticket Modal -->
<div class="modal fade" id="viewTicketModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">View Ticket</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>
            <div class="modal-body">
                <div id="ticketDetails">
                    <!-- Ticket details will be loaded here -->
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<!-- Reply Ticket Modal -->
<div class="modal fade" id="replyTicketModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Reply to Ticket</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>
            <div class="modal-body">
                <form id="replyTicketForm">
                    <input type="hidden" id="ticket_id" name="ticket_id">
                    <div class="mb-3">
                        <label for="reply_message" class="form-label">Your Reply</label>
                        <textarea class="form-control" id="reply_message" name="message" rows="5" required></textarea>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-primary" id="submitReply">Send Reply</button>
            </div>
        </div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.5.2/dist/js/bootstrap.bundle.min.js"></script>
<script>
$(function() {
    var sidebar = $('#userSidebar');
    var overlay = $('#sidebarOverlay');
    sidebar.on('show.bs.collapse', function() {
        if (window.innerWidth < 768) overlay.show();
    });
    sidebar.on('hide.bs.collapse', function() {
        overlay.hide();
    });
    overlay.on('click', function() {
        sidebar.collapse('hide');
    });
    $(window).on('resize', function() {
        if (window.innerWidth >= 768) overlay.hide();
    });
});

$(document).ready(function() {
    // Create Ticket
    $('#submitTicket').click(function() {
        var form = $('#createTicketForm');
        
        if (!form[0].checkValidity()) {
            form[0].reportValidity();
            return;
        }
        
        var btn = $(this);
        btn.prop('disabled', true).html('<span class="spinner-border spinner-border-sm"></span> Submitting...');
        
        $.ajax({
            url: '/Zealmart/api/support/create_ticket.php',
            method: 'POST',
            data: {
                subject: $('#subject').val(),
                message: $('#message').val()
            },
            success: function(response) {
                if (response.success) {
                    alert('Ticket created successfully');
                    $('#createTicketModal').modal('hide');
                    location.reload();
                } else {
                    alert(response.error || 'Failed to create ticket');
                }
            },
            error: function() {
                alert('An error occurred while creating the ticket');
            },
            complete: function() {
                btn.prop('disabled', false).text('Submit Ticket');
            }
        });
    });

    // View Ticket
    $('.view-ticket').click(function() {
        var ticketId = $(this).data('ticket-id');
        
        $.ajax({
            url: '/Zealmart/api/support/get_ticket.php',
            method: 'GET',
            data: { ticket_id: ticketId },
            success: function(response) {
                if (response.success) {
                    $('#ticketDetails').html(response.html);
                } else {
                    alert(response.error || 'Failed to load ticket details');
                }
            },
            error: function() {
                alert('An error occurred while loading ticket details');
            }
        });
    });

    // Reply to Ticket
    $('.reply-ticket').click(function() {
        $('#ticket_id').val($(this).data('ticket-id'));
    });

    $('#submitReply').click(function() {
        var form = $('#replyTicketForm');
        
        if (!form[0].checkValidity()) {
            form[0].reportValidity();
            return;
        }
        
        var btn = $(this);
        btn.prop('disabled', true).html('<span class="spinner-border spinner-border-sm"></span> Sending...');
        
        $.ajax({
            url: '/Zealmart/api/support/reply_ticket.php',
            method: 'POST',
            data: {
                ticket_id: $('#ticket_id').val(),
                message: $('#reply_message').val()
            },
            success: function(response) {
                if (response.success) {
                    alert('Reply sent successfully');
                    $('#replyTicketModal').modal('hide');
                    location.reload();
                } else {
                    alert(response.error || 'Failed to send reply');
                }
            },
            error: function() {
                alert('An error occurred while sending the reply');
            },
            complete: function() {
                btn.prop('disabled', false).text('Send Reply');
            }
        });
    });
});</script>

<style>
.ticket-message {
    margin-bottom: 1rem;
    padding: 1rem;
    border-radius: 0.25rem;
}

.ticket-message.user {
    background-color: #f8f9fa;
    margin-left: 2rem;
}

.ticket-message.admin {
    background-color: #e9ecef;
    margin-right: 2rem;
}

.ticket-meta {
    font-size: 0.875rem;
    color: #6c757d;
}
</style>
</body>
</html> 