<!-- Withdraw Modal -->
<div class="modal fade" id="withdrawModal" tabindex="-1" aria-labelledby="withdrawModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="withdrawModalLabel">Withdraw Earnings</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form id="withdrawForm">
                <div class="modal-body">
                    <div class="alert alert-info">
                        <strong>Available Balance:</strong> ₹<?php echo number_format($earnings['available_earnings'] ?? 0, 2); ?><br>
                        <strong>Minimum Withdrawal:</strong> ₹500.00
                    </div>

                    <div class="form-group mb-3">
                        <label for="withdrawAmount">Amount to Withdraw</label>
                        <div class="input-group">
                            <div class="input-group-prepend">
                                <span class="input-group-text">₹</span>
                            </div>
                            <input type="number" class="form-control" id="withdrawAmount" name="amount" 
                                   min="500" max="<?php echo $earnings['available_earnings'] ?? 0; ?>" step="0.01" required>
                        </div>
                        <small class="form-text text-muted">Enter amount between ₹500 and ₹<?php echo number_format($earnings['available_earnings'] ?? 0, 2); ?></small>
                    </div>

                    <div class="form-group mb-3">
                        <label for="withdrawMethod">Withdrawal Method</label>
                        <select class="form-select" id="withdrawMethod" name="method" required>
                            <option value="">Select Method</option>
                            <option value="bank">Bank Transfer</option>
                            <option value="upi">UPI Transfer</option>
                        </select>
                    </div>

                    <div class="alert alert-warning">
                        <small>
                            <i class="fas fa-exclamation-triangle"></i> Please note:
                            <ul class="mb-0">
                                <li>Withdrawals are processed within 24-48 hours</li>
                                <li>Ensure your banking details are up to date</li>
                                <li>Amount will be transferred to your registered account</li>
                            </ul>
                        </small>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-success">Request Withdrawal</button>
                </div>
            </form>
        </div>
    </div>
</div> 