<!-- Update KYC Modal -->
<div class="modal fade" id="updateKycModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Update KYC Details</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="alert alert-info">
                    <i class="fas fa-info-circle"></i>
                    Please ensure all details are entered correctly. Your KYC details will be verified by our team.
                </div>

                <form id="updateKycForm">
                    <div class="mb-3">
                        <label for="pan_number" class="form-label">PAN Number</label>
                        <input type="text" class="form-control" id="pan_number" name="pan_number" 
                               pattern="[A-Z]{5}[0-9]{4}[A-Z]{1}" maxlength="10" 
                               value="<?php echo htmlspecialchars($kycDetails['pan_number'] ?? ''); ?>" required>
                        <div class="form-text">Format: ABCDE1234F</div>
                    </div>

                    <div class="mb-3">
                        <label for="id_proof_type" class="form-label">ID Proof Type</label>
                        <select class="form-select" id="id_proof_type" name="id_proof_type" required>
                            <option value="">Select ID Proof Type</option>
                            <?php
                            $idProofTypes = ['Aadhaar Card', 'Driving License', 'Voter ID', 'Passport'];
                            foreach ($idProofTypes as $type):
                                $selected = ($kycDetails['id_proof_type'] ?? '') === $type ? 'selected' : '';
                            ?>
                            <option value="<?php echo $type; ?>" <?php echo $selected; ?>>
                                <?php echo $type; ?>
                            </option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <div class="mb-3">
                        <label for="id_proof_number" class="form-label">ID Proof Number</label>
                        <input type="text" class="form-control" id="id_proof_number" name="id_proof_number" 
                               value="<?php echo htmlspecialchars($kycDetails['id_proof_number'] ?? ''); ?>" required>
                        <div class="form-text">Enter your ID proof number without spaces</div>
                    </div>

                    <?php if ($kycDetails && $kycDetails['kyc_status'] !== 'pending'): ?>
                    <div class="alert alert-<?php echo $kycDetails['kyc_status'] === 'verified' ? 'success' : 'danger'; ?> mb-3">
                        <i class="fas fa-info-circle"></i>
                        Your KYC is currently <?php echo $kycDetails['kyc_status']; ?>. 
                        <?php if ($kycDetails['kyc_status'] === 'rejected'): ?>
                            You can update your details and submit again.
                        <?php endif; ?>
                    </div>
                    <?php endif; ?>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-primary" id="submitKyc">Update KYC</button>
            </div>
        </div>
    </div>
</div> 