<!-- Update Banking Details Modal -->
<div class="modal fade" id="updateBankingModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Update Banking Details</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="alert alert-info">
                    <i class="fas fa-info-circle"></i>
                    Please ensure all banking details are entered correctly. These details will be used for withdrawals.
                </div>

                <form id="updateBankingForm">
                    <!-- Bank Account Details -->
                    <h6 class="mb-3">Bank Account Details</h6>
                    <div class="mb-3">
                        <label for="bank_name" class="form-label">Bank Name</label>
                        <input type="text" class="form-control" id="bank_name" name="bank_name" 
                               value="<?php echo htmlspecialchars($bankingDetails['bank_name'] ?? ''); ?>" required>
                    </div>

                    <div class="mb-3">
                        <label for="account_number" class="form-label">Account Number</label>
                        <input type="text" class="form-control" id="account_number" name="account_number" 
                               pattern="[0-9]{9,18}" 
                               value="<?php echo htmlspecialchars($bankingDetails['account_number'] ?? ''); ?>" required>
                        <div class="form-text">Enter your account number (9-18 digits)</div>
                    </div>

                    <div class="mb-3">
                        <label for="account_type" class="form-label">Account Type</label>
                        <select class="form-select" id="account_type" name="account_type" required>
                            <option value="">Select Account Type</option>
                            <?php
                            $accountTypes = ['Savings', 'Current'];
                            foreach ($accountTypes as $type):
                                $selected = ($bankingDetails['account_type'] ?? '') === $type ? 'selected' : '';
                            ?>
                            <option value="<?php echo $type; ?>" <?php echo $selected; ?>>
                                <?php echo $type; ?>
                            </option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <div class="mb-3">
                        <label for="ifsc_code" class="form-label">IFSC Code</label>
                        <input type="text" class="form-control" id="ifsc_code" name="ifsc_code" 
                               pattern="^[A-Z]{4}0[A-Z0-9]{6}$" maxlength="11"
                               value="<?php echo htmlspecialchars($bankingDetails['ifsc_code'] ?? ''); ?>" required>
                        <div class="form-text">Format: ABCD0123456</div>
                    </div>

                    <div class="mb-3">
                        <label for="branch_name" class="form-label">Branch Name</label>
                        <input type="text" class="form-control" id="branch_name" name="branch_name" 
                               value="<?php echo htmlspecialchars($bankingDetails['branch_name'] ?? ''); ?>" required>
                    </div>

                    <!-- UPI Details -->
                    <h6 class="mb-3">UPI Details (Optional)</h6>
                    <div class="mb-3">
                        <label for="upi_id" class="form-label">UPI ID</label>
                        <input type="text" class="form-control" id="upi_id" name="upi_id" 
                               pattern="[a-zA-Z0-9.\-_]{2,256}@[a-zA-Z]{2,64}"
                               value="<?php echo htmlspecialchars($bankingDetails['upi_id'] ?? ''); ?>">
                        <div class="form-text">Format: username@bankname</div>
                    </div>

                    <div class="mb-3">
                        <label for="upi_number" class="form-label">UPI Number</label>
                        <input type="text" class="form-control" id="upi_number" name="upi_number" 
                               pattern="[0-9]{10}"
                               value="<?php echo htmlspecialchars($bankingDetails['upi_number'] ?? ''); ?>">
                        <div class="form-text">Enter your mobile number linked with UPI</div>
                    </div>

                    <div class="mb-3">
                        <label for="upi_app" class="form-label">UPI App</label>
                        <select class="form-select" id="upi_app" name="upi_app">
                            <option value="">Select UPI App</option>
                            <?php
                            $upiApps = ['Google Pay', 'PhonePe', 'Paytm', 'BHIM', 'Other'];
                            foreach ($upiApps as $app):
                                $selected = ($bankingDetails['upi_app'] ?? '') === $app ? 'selected' : '';
                            ?>
                            <option value="<?php echo $app; ?>" <?php echo $selected; ?>>
                                <?php echo $app; ?>
                            </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-primary" id="submitBanking">Update Details</button>
            </div>
        </div>
    </div>
</div> 