<?php
require_once '../config/config.php';
$user = new User();
if (!$user->isLoggedIn() || $user->getRole() !== 'user') {
    header('Location: ../index.php');
    exit;
}
$userId = $user->getId();
$db = Database::getInstance();
$conn = $db->getConnection();
// Get earnings summary
$query = "SELECT 
    SUM(CASE WHEN status = 'available' THEN amount ELSE 0 END) as available_earnings,
    SUM(CASE WHEN status = 'pending' THEN amount ELSE 0 END) as pending_earnings,
    SUM(CASE WHEN status = 'withdrawn' THEN amount ELSE 0 END) as withdrawn_earnings,
    SUM(amount) as total_earnings
    FROM earnings WHERE user_id = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("i", $userId);
$stmt->execute();
$earnings = $stmt->get_result()->fetch_assoc();
// Get withdrawal history
$withdrawals = [];
$stmt = $conn->prepare("SELECT id, amount, status, created_at, processed_at FROM withdrawals WHERE user_id = ? ORDER BY created_at DESC");
$stmt->bind_param("i", $userId);
$stmt->execute();
$result = $stmt->get_result();
while ($row = $result->fetch_assoc()) {
    $withdrawals[] = $row;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Earnings - Zealmart</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <style>
        body { background: #e5e5e5; }
        .sidebar {
            min-height: 100vh;
            background: linear-gradient(180deg, #3a86ff 0%, #8338ec 100%);
            padding-top: 20px;
            border-top-right-radius: 20px;
            border-bottom-right-radius: 20px;
            box-shadow: 2px 0 12px rgba(51,51,51,0.08);
            transition: background 0.3s;
        }
        .sidebar .sidebar-brand {
            display: flex;
            flex-direction: column;
            align-items: center;
            margin-bottom: 2rem;
        }
        .sidebar .sidebar-logo {
            width: 60px;
            height: 60px;
            border-radius: 50%;
            background: #fff;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-bottom: 0.5rem;
            box-shadow: 0 2px 8px rgba(0,0,0,0.08);
        }
        .sidebar .sidebar-logo i {
            font-size: 2rem;
            color: #3a86ff;
        }
        .sidebar .sidebar-title {
            color: #fff;
            font-weight: bold;
            font-size: 1.2rem;
            letter-spacing: 1px;
        }
        .sidebar-section {
            color: #e0e1dd;
            font-size: 0.85rem;
            text-transform: uppercase;
            margin: 1.5rem 0 0.5rem 1rem;
            letter-spacing: 0.08em;
        }
        .sidebar a {
            color: #fff;
            padding: 12px 22px;
            display: flex;
            align-items: center;
            border-radius: 8px 0 0 8px;
            margin-bottom: 6px;
            font-size: 1.05rem;
            transition: background 0.2s, color 0.2s, box-shadow 0.2s;
        }
        .sidebar a.active, .sidebar a:hover {
            background: rgba(255, 255, 255, 0.15);
            color: #ffbe0b;
            box-shadow: 2px 2px 8px rgba(0,0,0,0.07);
            font-weight: bold;
        }
        .sidebar a i {
            margin-right: 12px;
            font-size: 1.2em;
        }
        @media (max-width: 767.98px) {
            .sidebar {
                position: fixed;
                z-index: 1050;
                left: 0;
                top: 0;
                width: 220px;
                height: 100vh;
                transform: translateX(-100%);
                transition: transform 0.3s ease;
                border-radius: 0 20px 20px 0;
            }
            .sidebar.collapse.show {
                transform: translateX(0);
            }
            .main-content {
                padding: 10px;
            }
        }
        .main-content {
            background: #fff;
            min-height: 100vh;
            padding: 2rem 2rem 2rem 2rem;
        }
    </style>
</head>
<body>
<div class="container-fluid">
    <div class="row">
        <!-- Sidebar Overlay (for mobile) -->
        <div id="sidebarOverlay" style="display:none;position:fixed;top:0;left:0;width:100vw;height:100vh;background:rgba(0,0,0,0.3);z-index:1049;"></div>
        <!-- Sidebar Toggle Button (visible on mobile) -->
        <button class="btn btn-dark d-md-none m-2" type="button" data-toggle="collapse" data-target="#userSidebar" aria-controls="userSidebar" aria-expanded="false" aria-label="Toggle navigation">
            <i class="fas fa-bars"></i> Menu
        </button>
        <?php include_once '../includes/user_sidebar.php'; ?>
        <main class="col-md-10 ml-sm-auto main-content">
<div class="row mb-4">
    <div class="col-md-6">
        <div class="card mb-4">
            <div class="card-body">
                <h5 class="card-title">Earnings Summary</h5>
                <p><strong>Available:</strong> ₹<?php echo number_format($earnings['available_earnings'] ?? 0, 2); ?><br>
                <strong>Pending:</strong> ₹<?php echo number_format($earnings['pending_earnings'] ?? 0, 2); ?><br>
                <strong>Withdrawn:</strong> ₹<?php echo number_format($earnings['withdrawn_earnings'] ?? 0, 2); ?><br>
                <strong>Total:</strong> ₹<?php echo number_format($earnings['total_earnings'] ?? 0, 2); ?></p>
                <div class="alert alert-info mb-0">
                    <small>Note: Available balance is reduced only after admin approval of your withdrawal request.</small>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="row mb-4">
    <div class="col-md-10">
        <div class="card">
            <div class="card-body">
                <h5 class="card-title">Withdrawal History</h5>
                <div class="table-responsive">
                    <table class="table table-bordered table-striped">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Amount</th>
                                <th>Status</th>
                                <th>Requested At</th>
                                <th>Processed At</th>
                            </tr>
                        </thead>
                        <tbody>
                        <?php if (empty($withdrawals)): ?>
                            <tr><td colspan="5" class="text-center">No withdrawal requests found</td></tr>
                        <?php else: ?>
                            <?php foreach ($withdrawals as $w): ?>
                            <tr>
                                <td><?php echo $w['id']; ?></td>
                                <td>₹<?php echo number_format($w['amount'], 2); ?></td>
                                <td><span class="badge bg-<?php
                                    echo $w['status'] === 'pending' ? 'warning' : ($w['status'] === 'approved' ? 'success' : 'danger');
                                ?>"><?php echo ucfirst($w['status']); ?></span></td>
                                <td><?php echo date('Y-m-d H:i', strtotime($w['created_at'])); ?></td>
                                <td><?php echo $w['processed_at'] ? date('Y-m-d H:i', strtotime($w['processed_at'])) : '-'; ?></td>
                            </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
        </main>
    </div>
</div>
<script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.5.2/dist/js/bootstrap.bundle.min.js"></script>
<script>
$(function() {
    var sidebar = $('#userSidebar');
    var overlay = $('#sidebarOverlay');
    sidebar.on('show.bs.collapse', function() {
        if (window.innerWidth < 768) overlay.show();
    });
    sidebar.on('hide.bs.collapse', function() {
        overlay.hide();
    });
    overlay.on('click', function() {
        sidebar.collapse('hide');
    });
    $(window).on('resize', function() {
        if (window.innerWidth >= 768) overlay.hide();
    });
});
</script>
</body>
</html> 