<?php
require_once '../config/config.php';

// Check if user is logged in
$user = new User();
if (!$user->isLoggedIn() || $user->getRole() !== 'user') {
    header('Location: ../index.php');
    exit;
}

// Get user data
$userId = $user->getId();
$userData = $user->getCurrentUser();

// Get user stats
$db = Database::getInstance();
$connection = $db->getConnection();

// Get total earnings
$query = "SELECT 
            SUM(CASE WHEN status = 'available' THEN amount ELSE 0 END) as available_earnings,
            SUM(CASE WHEN status = 'pending' THEN amount ELSE 0 END) as pending_earnings,
            SUM(amount) as total_earnings
          FROM earnings 
          WHERE user_id = ?";
$stmt = $connection->prepare($query);
$stmt->bind_param("i", $userId);
$stmt->execute();
$earnings = $stmt->get_result()->fetch_assoc();

// Get PIN counts
$query = "SELECT 
            COUNT(*) as total_pins,
            SUM(CASE WHEN status = 'created' THEN 1 ELSE 0 END) as available_pins,
            SUM(CASE WHEN status = 'activated' THEN 1 ELSE 0 END) as used_pins
          FROM pins 
          WHERE current_owner = ?";
$stmt = $connection->prepare($query);
$stmt->bind_param("i", $userId);
$stmt->execute();
$pins = $stmt->get_result()->fetch_assoc();

// Get referral count
$query = "SELECT COUNT(*) as referral_count 
          FROM genealogy 
          WHERE parent_id = ?";
$stmt = $connection->prepare($query);
$stmt->bind_param("i", $userId);
$stmt->execute();
$referrals = $stmt->get_result()->fetch_assoc();

// Get KYC status
$query = "SELECT kyc_status 
          FROM user_profiles 
          WHERE user_id = ?";
$stmt = $connection->prepare($query);
$stmt->bind_param("i", $userId);
$stmt->execute();
$kyc = $stmt->get_result()->fetch_assoc();

// Get KYC details
$sql = "SELECT * FROM user_profiles WHERE user_id = ?";
$stmt = $connection->prepare($sql);
$stmt->bind_param("i", $userId);
$stmt->execute();
$kycDetails = $stmt->get_result()->fetch_assoc();

// Get banking details
$sql = "SELECT * FROM banking_details WHERE user_id = ?";
$stmt = $connection->prepare($sql);
$stmt->bind_param("i", $userId);
$stmt->execute();
$bankingDetails = $stmt->get_result()->fetch_assoc();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Zealmart User Dashboard</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <style>
        body {
            background: #e5e5e5;
        }
        .sidebar {
            min-height: 100vh;
            background: linear-gradient(180deg, #3a86ff 0%, #8338ec 100%);
            padding-top: 20px;
            border-top-right-radius: 20px;
            border-bottom-right-radius: 20px;
            box-shadow: 2px 0 12px rgba(51,51,51,0.08);
            transition: background 0.3s;
        }
        .sidebar .sidebar-brand {
            display: flex;
            flex-direction: column;
            align-items: center;
            margin-bottom: 2rem;
        }
        .sidebar .sidebar-logo {
            width: 60px;
            height: 60px;
            border-radius: 50%;
            background: #fff;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-bottom: 0.5rem;
            box-shadow: 0 2px 8px rgba(0,0,0,0.08);
        }
        .sidebar .sidebar-logo i {
            font-size: 2rem;
            color: #3a86ff;
        }
        .sidebar .sidebar-title {
            color: #fff;
            font-weight: bold;
            font-size: 1.2rem;
            letter-spacing: 1px;
        }
        .sidebar-section {
            color: #e0e1dd;
            font-size: 0.85rem;
            text-transform: uppercase;
            margin: 1.5rem 0 0.5rem 1rem;
            letter-spacing: 0.08em;
        }
        .sidebar a {
            color: #fff;
            padding: 12px 22px;
            display: flex;
            align-items: center;
            border-radius: 8px 0 0 8px;
            margin-bottom: 6px;
            font-size: 1.05rem;
            transition: background 0.2s, color 0.2s, box-shadow 0.2s;
        }
        .sidebar a.active, .sidebar a:hover {
            background: rgba(255, 255, 255, 0.15);
            color: #ffbe0b;
            box-shadow: 2px 2px 8px rgba(0,0,0,0.07);
            font-weight: bold;
        }
        .sidebar a i {
            margin-right: 12px;
            font-size: 1.2em;
        }
        @media (max-width: 767.98px) {
            .sidebar {
                position: fixed;
                z-index: 1050;
                left: 0;
                top: 0;
                width: 220px;
                height: 100vh;
                transform: translateX(-100%);
                transition: transform 0.3s ease;
                border-radius: 0 20px 20px 0;
            }
            .sidebar.collapse.show {
                transform: translateX(0);
            }
            .main-content {
                padding: 10px;
            }
        }
        .main-content {
            background: #fff;
            min-height: 100vh;
            padding: 2rem 2rem 2rem 2rem;
        }
    </style>
</head>
<body>
<div class="container-fluid">
    <div class="row">
        <!-- Sidebar Overlay (for mobile) -->
        <div id="sidebarOverlay" style="display:none;position:fixed;top:0;left:0;width:100vw;height:100vh;background:rgba(0,0,0,0.3);z-index:1049;"></div>
        <!-- Sidebar Toggle Button (visible on mobile) -->
        <button class="btn btn-dark d-md-none m-2" type="button" data-toggle="collapse" data-target="#userSidebar" aria-controls="userSidebar" aria-expanded="false" aria-label="Toggle navigation">
            <i class="fas fa-bars"></i> Menu
        </button>
        <?php include_once '../includes/user_sidebar.php'; ?>
        <main class="col-md-10 ml-sm-auto main-content">
            <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                <h1 class="h2">Dashboard</h1>
                <div class="btn-toolbar mb-2 mb-md-0">
                    <div class="btn-group me-2">
                        <button type="button" class="btn btn-sm btn-outline-primary" id="editProfileBtn">
                            <i class="fas fa-user-edit"></i> Edit Profile
                        </button>
                        <button type="button" class="btn btn-sm btn-outline-info" id="viewTreeBtn">
                            <i class="fas fa-sitemap"></i> View Tree
                        </button>
                    </div>
                </div>
            </div>

            <!-- Stats Cards -->
            <div class="row mb-4">
                <!-- Earnings Card -->
                <div class="col-md-4">
                    <div class="card">
                        <div class="card-body">
                            <h5 class="card-title">Earnings</h5>
                            <p class="card-text">
                                <strong>Available:</strong> ₹<?php echo number_format($earnings['available_earnings'] ?? 0, 2); ?><br>
                                <strong>Pending:</strong> ₹<?php echo number_format($earnings['pending_earnings'] ?? 0, 2); ?><br>
                                <strong>Total:</strong> ₹<?php echo number_format($earnings['total_earnings'] ?? 0, 2); ?>
                            </p>
                            <?php if ($earnings['available_earnings'] >= 500): ?>
                            <button class="btn btn-success btn-sm" id="withdrawBtn">
                                <i class="fas fa-money-bill-wave"></i> Withdraw
                            </button>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <!-- PINs Card -->
                <div class="col-md-4">
                    <div class="card">
                        <div class="card-body">
                            <h5 class="card-title">PINs</h5>
                            <p class="card-text">
                                <strong>Available:</strong> <?php echo $pins['available_pins']; ?><br>
                                <strong>Used:</strong> <?php echo $pins['used_pins']; ?><br>
                                <strong>Total:</strong> <?php echo $pins['total_pins']; ?>
                            </p>
                            <button class="btn btn-primary btn-sm" id="managePinsBtn">
                                <i class="fas fa-key"></i> Manage PINs
                            </button>
                        </div>
                    </div>
                </div>

                <!-- Referrals Card -->
                <div class="col-md-4">
                    <div class="card">
                        <div class="card-body">
                            <h5 class="card-title">Network</h5>
                            <p class="card-text">
                                <strong>Direct Referrals:</strong> <?php echo $referrals['referral_count']; ?><br>
                                <strong>KYC Status:</strong> <?php echo ucfirst($kyc['kyc_status'] ?? 'pending'); ?>
                            </p>
                            <button class="btn btn-info btn-sm" id="viewReferralsBtn">
                                <i class="fas fa-users"></i> View Network
                            </button>
                        </div>
                    </div>
                </div>
            </div>

            <!-- User Profile Summary -->
            <div class="row mb-4">
                <div class="col-md-4">
                    <div class="card">
                        <div class="card-body">
                            <h5 class="card-title">Profile Information</h5>
                            <p class="mb-1"><strong>Username:</strong> <?php echo htmlspecialchars($userData['username']); ?></p>
                            <p class="mb-1"><strong>Name:</strong> <?php echo htmlspecialchars($userData['full_name']); ?></p>
                            <p class="mb-1"><strong>Email:</strong> <?php echo htmlspecialchars($userData['email']); ?></p>
                            <p class="mb-0"><strong>Status:</strong> 
                                <span class="badge bg-<?php echo $userData['status'] === 'active' ? 'success' : 'warning'; ?>">
                                    <?php echo ucfirst($userData['status']); ?>
                                </span>
                            </p>
                        </div>
                    </div>
                </div>

                <!-- KYC Details -->
                <div class="col-md-4">
                    <div class="card">
                        <div class="card-body">
                            <div class="d-flex justify-content-between align-items-center mb-3">
                                <h5 class="card-title mb-0">KYC Details</h5>
                                <button type="button" class="btn btn-sm btn-primary" data-toggle="modal" data-target="#updateKycModal">
                                    <i class="fas fa-edit"></i> Update
                                </button>
                            </div>
                            <?php if ($kycDetails): ?>
                            <p class="mb-1"><strong>PAN Number:</strong> <?php echo htmlspecialchars($kycDetails['pan_number']); ?></p>
                            <p class="mb-1"><strong>ID Proof Type:</strong> <?php echo htmlspecialchars($kycDetails['id_proof_type']); ?></p>
                            <p class="mb-1"><strong>ID Proof Number:</strong> <?php echo htmlspecialchars($kycDetails['id_proof_number']); ?></p>
                            <p class="mb-0"><strong>Status:</strong> 
                                <span class="badge bg-<?php 
                                    echo match($kycDetails['kyc_status']) {
                                        'verified' => 'success',
                                        'rejected' => 'danger',
                                        default => 'warning'
                                    };
                                ?>">
                                    <?php echo ucfirst($kycDetails['kyc_status']); ?>
                                </span>
                            </p>
                            <?php else: ?>
                            <div class="alert alert-warning mb-0">
                                <i class="fas fa-exclamation-triangle"></i> KYC details not updated
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <!-- Banking Details -->
                <div class="col-md-4">
                    <div class="card">
                        <div class="card-body">
                            <div class="d-flex justify-content-between align-items-center mb-3">
                                <h5 class="card-title mb-0">Banking Details</h5>
                                <button type="button" class="btn btn-sm btn-primary" data-toggle="modal" data-target="#updateBankingModal">
                                    <i class="fas fa-edit"></i> Update
                                </button>
                            </div>
                            <?php if ($bankingDetails): ?>
                            <div class="mb-3">
                                <h6 class="text-muted">Bank Account</h6>
                                <p class="mb-1"><strong>Bank Name:</strong> <?php echo htmlspecialchars($bankingDetails['bank_name']); ?></p>
                                <p class="mb-1"><strong>Account Number:</strong> <?php echo htmlspecialchars($bankingDetails['account_number']); ?></p>
                                <p class="mb-1"><strong>Account Type:</strong> <?php echo htmlspecialchars($bankingDetails['account_type']); ?></p>
                                <p class="mb-1"><strong>IFSC Code:</strong> <?php echo htmlspecialchars($bankingDetails['ifsc_code']); ?></p>
                                <p class="mb-0"><strong>Branch:</strong> <?php echo htmlspecialchars($bankingDetails['branch_name']); ?></p>
                            </div>
                            <?php if ($bankingDetails['upi_id'] || $bankingDetails['upi_number']): ?>
                            <div>
                                <h6 class="text-muted">UPI Details</h6>
                                <?php if ($bankingDetails['upi_id']): ?>
                                <p class="mb-1"><strong>UPI ID:</strong> <?php echo htmlspecialchars($bankingDetails['upi_id']); ?></p>
                                <?php endif; ?>
                                <?php if ($bankingDetails['upi_number']): ?>
                                <p class="mb-1"><strong>UPI Number:</strong> <?php echo htmlspecialchars($bankingDetails['upi_number']); ?></p>
                                <?php endif; ?>
                                <?php if ($bankingDetails['upi_app']): ?>
                                <p class="mb-0"><strong>UPI App:</strong> <?php echo htmlspecialchars($bankingDetails['upi_app']); ?></p>
                                <?php endif; ?>
                            </div>
                            <?php endif; ?>
                            <?php else: ?>
                            <div class="alert alert-warning mb-0">
                                <i class="fas fa-exclamation-triangle"></i> Banking details not updated
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Quick Actions -->
            <div class="row mb-4">
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-body">
                            <h5 class="card-title">Quick Actions</h5>
                            <div class="d-grid gap-2">
                                <button class="btn btn-outline-primary btn-sm" id="updateKycBtn">
                                    <i class="fas fa-id-card"></i> Update KYC
                                </button>
                                <button class="btn btn-outline-info btn-sm" id="updateBankingBtn">
                                    <i class="fas fa-university"></i> Update Banking Details
                                </button>
                                <button class="btn btn-outline-success btn-sm" id="supportBtn">
                                    <i class="fas fa-headset"></i> Contact Support
                                </button>
                                <button class="btn btn-outline-warning btn-sm" id="changePasswordBtn">
                                    <i class="fas fa-key"></i> Change Password
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </main>
    </div>
</div>

<!-- Include necessary modals -->
<?php 
include_once 'modals/edit_profile.php';
include_once 'modals/change_password.php';
include_once 'modals/update_kyc.php';
include_once 'modals/update_banking.php';
include_once 'modals/withdraw.php';
?>

<script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.5.2/dist/js/bootstrap.bundle.min.js"></script>
<script>
$(document).ready(function() {
    // Edit Profile Button
    $('#editProfileBtn').click(function() {
        $('#editProfileModal').modal('show');
    });
    // Save Profile (moved from modal include)
    $('#saveProfile').click(function() {
        var form = $('#editProfileForm');
        if (!form[0].checkValidity()) {
            form[0].reportValidity();
            return;
        }
        var btn = $(this);
        btn.prop('disabled', true).html('<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span> Saving...');
        $.ajax({
            url: '/Zealmart/api/users/update_profile.php',
            method: 'POST',
            data: {
                full_name: $('#full_name').val(),
                email: $('#email').val(),
                phone: $('#phone').val()
            },
            success: function(response) {
                if (response.success) {
                    alert('Profile updated successfully');
                    $('#editProfileModal').modal('hide');
                    location.reload();
                } else {
                    alert(response.error || 'An error occurred while updating profile');
                }
            },
            error: function() {
                alert('An error occurred while updating profile');
            },
            complete: function() {
                btn.prop('disabled', false).text('Save Changes');
            }
        });
    });
    $('#editProfileModal').on('hidden.bs.modal', function() {
        $('#editProfileForm')[0].reset();
    });
    // View Tree Button
    $('#viewTreeBtn').click(function() {
        window.location.href = 'genealogy.php';
    });
    // Manage PINs Button
    $('#managePinsBtn').click(function() {
        window.location.href = 'pins/manage.php';
    });
    // View Referrals Button
    $('#viewReferralsBtn').click(function() {
        window.location.href = 'referrals.php';
    });
    // Update KYC Button
    $('#updateKycBtn').click(function() {
        $('#updateKycModal').modal('show');
    });
    // Update Banking Button
    $('#updateBankingBtn').click(function() {
        $('#updateBankingModal').modal('show');
    });
    // Support Button
    $('#supportBtn').click(function() {
        window.location.href = 'support.php';
    });
    // Change Password Button
    $('#changePasswordBtn').click(function() {
        $('#changePasswordModal').modal('show');
    });
    // Withdraw Button
    $('#withdrawBtn').click(function() {
        $('#withdrawModal').modal('show');
    });
    // Change Password Modal JS
    function showError(message) {
        $('#errorMessage').text(message);
        $('#passwordError').removeClass('d-none');
    }
    function hideError() {
        $('#passwordError').addClass('d-none');
        $('#errorMessage').text('');
    }
    $('#submitPassword').click(function() {
        var form = $('#changePasswordForm');
        hideError();
        if (!form[0].checkValidity()) {
            form[0].reportValidity();
            return;
        }
        if ($('#new_password').val() !== $('#confirm_password').val()) {
            showError('New passwords do not match');
            return;
        }
        var btn = $(this);
        btn.prop('disabled', true).html('<span class="spinner-border spinner-border-sm"></span> Updating...');
        $.ajax({
            url: '/Zealmart/api/users/change_password.php',
            method: 'POST',
            data: {
                current_password: $('#current_password').val(),
                new_password: $('#new_password').val(),
                confirm_password: $('#confirm_password').val()
            },
            success: function(response) {
                if (response.success) {
                    alert('Password changed successfully');
                    $('#changePasswordModal').modal('hide');
                    form[0].reset();
                } else {
                    showError(response.error || 'Failed to change password');
                }
            },
            error: function(xhr, status, error) {
                showError('An error occurred while changing password: ' + error);
            },
            complete: function() {
                btn.prop('disabled', false).text('Change Password');
            }
        });
    });
    $('#changePasswordModal').on('hidden.bs.modal', function() {
        $('#changePasswordForm')[0].reset();
        hideError();
    });
    $('#changePasswordForm input').on('input', function() {
        hideError();
    });
    // KYC Modal JS
    $('#pan_number').on('input', function() {
        this.value = this.value.toUpperCase();
    });
    $('#submitKyc').click(function() {
        var form = $('#updateKycForm');
        if (!form[0].checkValidity()) {
            form[0].reportValidity();
            return;
        }
        var btn = $(this);
        btn.prop('disabled', true).html('<span class="spinner-border spinner-border-sm"></span> Updating...');
        $.ajax({
            url: '/Zealmart/api/users/update_kyc.php',
            method: 'POST',
            data: {
                pan_number: $('#pan_number').val(),
                id_proof_type: $('#id_proof_type').val(),
                id_proof_number: $('#id_proof_number').val()
            },
            success: function(response) {
                if (response.success) {
                    alert('KYC details updated successfully');
                    $('#updateKycModal').modal('hide');
                    location.reload();
                } else {
                    alert(response.error || 'Failed to update KYC details');
                }
            },
            error: function() {
                alert('An error occurred while updating KYC details');
            },
            complete: function() {
                btn.prop('disabled', false).text('Update KYC');
            }
        });
    });
    // Banking Modal JS
    $('#ifsc_code').on('input', function() {
        this.value = this.value.toUpperCase();
    });
    $('#submitBanking').click(function() {
        var form = $('#updateBankingForm');
        if (!form[0].checkValidity()) {
            form[0].reportValidity();
            return;
        }
        var btn = $(this);
        btn.prop('disabled', true).html('<span class="spinner-border spinner-border-sm"></span> Updating...');
        $.ajax({
            url: '/Zealmart/api/users/update_banking.php',
            method: 'POST',
            data: {
                bank_name: $('#bank_name').val(),
                account_number: $('#account_number').val(),
                account_type: $('#account_type').val(),
                ifsc_code: $('#ifsc_code').val(),
                branch_name: $('#branch_name').val(),
                upi_id: $('#upi_id').val(),
                upi_number: $('#upi_number').val(),
                upi_app: $('#upi_app').val()
            },
            success: function(response) {
                if (response.success) {
                    alert('Banking details updated successfully');
                    $('#updateBankingModal').modal('hide');
                    location.reload();
                } else {
                    alert(response.error || 'Failed to update banking details');
                }
            },
            error: function() {
                alert('An error occurred while updating banking details');
            },
            complete: function() {
                btn.prop('disabled', false).text('Update Details');
            }
        });
    });
    // Withdraw Modal JS
    $('#withdrawForm').on('submit', function(e) {
        e.preventDefault();
        var amount = parseFloat($('#withdrawAmount').val());
        var availableBalance = <?php echo $earnings['available_earnings'] ?? 0; ?>;
        var method = $('#withdrawMethod').val();
        if (!method) {
            alert('Please select a withdrawal method');
            return;
        }
        if (isNaN(amount) || amount <= 0 || amount > availableBalance) {
            alert('Invalid withdrawal amount');
            return;
        }
        var btn = $(this);
        btn.prop('disabled', true).html('<span class="spinner-border spinner-border-sm"></span> Processing...');
        $.ajax({
            url: '/Zealmart/user/api/withdraw.php',
            method: 'POST',
            data: {
                amount: amount,
                method: method
            },
            success: function(response) {
                if (response.success) {
                    alert('Withdrawal request submitted successfully');
                    $('#withdrawModal').modal('hide');
                    location.reload();
                } else {
                    alert(response.error || response.message || 'An error occurred while processing withdrawal');
                }
            },
            error: function() {
                alert('An error occurred while processing withdrawal');
            },
            complete: function() {
                btn.prop('disabled', false).text('Withdraw');
            }
        });
    });
});

$(function() {
    var sidebar = $('#userSidebar');
    var overlay = $('#sidebarOverlay');
    sidebar.on('show.bs.collapse', function() {
        if (window.innerWidth < 768) overlay.show();
    });
    sidebar.on('hide.bs.collapse', function() {
        overlay.hide();
    });
    overlay.on('click', function() {
        sidebar.collapse('hide');
    });
    $(window).on('resize', function() {
        if (window.innerWidth >= 768) overlay.hide();
    });
});
</script>

<style>
.card {
    border-radius: 0.5rem;
    box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075);
    height: 100%;
}

.card-title {
    color: #6c757d;
    font-size: 0.875rem;
    text-transform: uppercase;
    letter-spacing: 0.1em;
}

.text-muted {
    font-size: 0.875rem;
}

.alert {
    margin-bottom: 0;
    padding: 0.5rem 1rem;
}

.alert i {
    margin-right: 0.5rem;
}
</style> 