<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

function log_debug($msg) {
    file_put_contents(__DIR__ . '/withdraw_debug.log', date('c') . ' ' . $msg . PHP_EOL, FILE_APPEND);
}

log_debug('POST: ' . json_encode($_POST));

require_once '../../config/config.php';

header('Content-Type: application/json');

$user = new User();
if (!$user->isLoggedIn() || $user->getRole() !== 'user') {
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit;
}

$userId = $user->getId();
$amount = floatval($_POST['amount'] ?? 0);
$method = $_POST['method'] ?? '';

if (empty($method)) {
    echo json_encode(['success' => false, 'message' => 'Please select a withdrawal method']);
    exit;
}

if ($amount < 500) {
    echo json_encode(['success' => false, 'message' => 'Minimum withdrawal is ₹500']);
    exit;
}

$db = Database::getInstance();
$conn = $db->getConnection();

// Check available earnings
$stmt = $conn->prepare("SELECT COALESCE(SUM(amount),0) as available FROM earnings WHERE user_id = ? AND status = 'available'");
$stmt->bind_param("i", $userId);
$stmt->execute();
$res = $stmt->get_result()->fetch_assoc();
$available = floatval($res['available']);

if ($amount > $available) {
    echo json_encode(['success' => false, 'message' => 'Amount exceeds available balance']);
    exit;
}

// Insert withdrawal request
$stmt = $conn->prepare("INSERT INTO withdrawals (user_id, amount, status) VALUES (?, ?, 'pending')");
$stmt->bind_param("id", $userId, $amount);
if ($stmt->execute()) {
    echo json_encode(['success' => true, 'message' => 'Withdrawal request submitted successfully!']);
} else {
    log_debug('MySQL error: ' . $stmt->error);
    echo json_encode(['success' => false, 'message' => 'Failed to submit withdrawal request', 'error' => $stmt->error]);
}
?> 