<?php
require_once '../config/config.php';

$user = new User();
if ($user->isLoggedIn()) {
    header('Location: ' . ($user->isAdmin() ? ADMIN_URL : USER_URL) . '/dashboard.php');
    exit;
}

$error = '';
$success = '';
$ref_username = isset($_GET['ref']) ? htmlspecialchars($_GET['ref']) : '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $full_name = trim($_POST['full_name'] ?? '');
    $email = trim($_POST['email'] ?? '');
    $phone = trim($_POST['phone'] ?? '');
    $password = $_POST['password'] ?? '';
    $confirm_password = $_POST['confirm_password'] ?? '';
    $ref_username = trim($_POST['ref_username'] ?? '');

    // Validation
    if (empty($full_name) || empty($email) || empty($phone) || empty($password) || empty($confirm_password)) {
        $error = 'All fields are required.';
    } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $error = 'Please enter a valid email address.';
    } elseif (strlen($password) < MIN_PASSWORD_LENGTH) {
        $error = 'Password must be at least ' . MIN_PASSWORD_LENGTH . ' characters long.';
    } elseif ($password !== $confirm_password) {
        $error = 'Passwords do not match.';
    } else {
        $result = $user->register($full_name, $email, $phone, $password, $ref_username);
        if ($result['success']) {
            // Insert genealogy entry for the new user
            $db = Database::getInstance();
            $connection = $db->getConnection();
            $user_id = $result['user_id'];
            $parent_id = $result['parent_id'];
            // Check if genealogy already exists
            $check = $connection->prepare("SELECT id FROM genealogy WHERE user_id = ?");
            $check->bind_param("i", $user_id);
            $check->execute();
            $check->store_result();
            if ($check->num_rows == 0) {
                if ($parent_id) {
                    $query = "INSERT INTO genealogy (user_id, parent_id, placement_level, position) VALUES (?, ?, 1, 1)";
                    $stmt = $connection->prepare($query);
                    $stmt->bind_param("ii", $user_id, $parent_id);
                } else {
                    $query = "INSERT INTO genealogy (user_id, parent_id, placement_level, position) VALUES (?, NULL, 1, 1)";
                    $stmt = $connection->prepare($query);
                    $stmt->bind_param("i", $user_id);
                }
                $stmt->execute();
            }
            $success = 'Registration successful! Your username is: ' . $result['username'];
        } else {
            $error = $result['error'] ?? 'Registration failed. Please try again.';
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo APP_NAME; ?> - Register</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <style>
        body {
            background-color: #f8f9fa;
            padding: 40px 0;
        }
        .register-form {
            background: white;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 0 20px rgba(0,0,0,0.1);
            max-width: 500px;
            margin: 0 auto;
        }
        .brand {
            text-align: center;
            margin-bottom: 30px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="register-form">
            <div class="brand">
                <h1><?php echo BRAND_NAME; ?></h1>
                <p>Create New Account</p>
            </div>

            <?php if ($error): ?>
                <div class="alert alert-danger"><?php echo $error; ?></div>
            <?php endif; ?>

            <?php if ($success): ?>
                <div class="alert alert-success">
                    <?php echo $success; ?>
                    <br>
                    <a href="../index.php">Click here to login</a>
                </div>
            <?php else: ?>
                <form method="POST" action="">
                    <input type="hidden" name="ref_username" value="<?php echo $ref_username; ?>">
                    <div class="form-group">
                        <label for="full_name">Full Name</label>
                        <input type="text" class="form-control" id="full_name" name="full_name" 
                               value="<?php echo isset($_POST['full_name']) ? htmlspecialchars($_POST['full_name']) : ''; ?>" required>
                    </div>

                    <div class="form-group">
                        <label for="email">Email Address</label>
                        <input type="email" class="form-control" id="email" name="email"
                               value="<?php echo isset($_POST['email']) ? htmlspecialchars($_POST['email']) : ''; ?>" required>
                    </div>

                    <div class="form-group">
                        <label for="phone">Phone Number</label>
                        <input type="tel" class="form-control" id="phone" name="phone"
                               value="<?php echo isset($_POST['phone']) ? htmlspecialchars($_POST['phone']) : ''; ?>" required>
                    </div>

                    <div class="form-group">
                        <label for="password">Password</label>
                        <input type="password" class="form-control" id="password" name="password" 
                               minlength="<?php echo MIN_PASSWORD_LENGTH; ?>" required>
                    </div>

                    <div class="form-group">
                        <label for="confirm_password">Confirm Password</label>
                        <input type="password" class="form-control" id="confirm_password" name="confirm_password" 
                               minlength="<?php echo MIN_PASSWORD_LENGTH; ?>" required>
                    </div>

                    <button type="submit" class="btn btn-primary btn-block">Register</button>

                    <div class="mt-3 text-center">
                        Already have an account? <a href="../index.php">Login here</a>
                    </div>
                </form>
            <?php endif; ?>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.5.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html> 