<?php
// Database Configuration
if (!defined('DB_HOST')) define('DB_HOST', 'localhost');
if (!defined('DB_USER')) define('DB_USER', 'root');
if (!defined('DB_PASS')) define('DB_PASS', '');
if (!defined('DB_NAME')) define('DB_NAME', 'zealmart');

// Error Reporting
error_reporting(E_ALL);
ini_set('display_errors', 0);
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/../logs/error.log');

// Session Configuration
ini_set('session.cookie_httponly', 1);
ini_set('session.use_only_cookies', 1);
ini_set('session.cookie_secure', 0); // Set to 1 if using HTTPS

// Application Settings
if (!defined('SITE_URL')) define('SITE_URL', '/Zealmart');
if (!defined('MIN_PASSWORD_LENGTH')) define('MIN_PASSWORD_LENGTH', 8);

// Time Zone
date_default_timezone_set('Asia/Kolkata');

// Start Session
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Load Configuration Files
require_once __DIR__ . '/constants.php';
require_once __DIR__ . '/database.php';

// Auto-load Classes
spl_autoload_register(function ($class_name) {
    $class_file = CLASSES_PATH . '/' . $class_name . '.php';
    if (file_exists($class_file)) {
        require_once $class_file;
    }
});

// Initialize Database Connection
$db = Database::getInstance();

// Security Headers
header('X-Frame-Options: DENY');
header('X-XSS-Protection: 1; mode=block');
header('X-Content-Type-Options: nosniff');
?>