<?php
require_once '../../config/config.php';

// Set headers
header('Content-Type: application/json');

// Check if user is logged in
$user = new User();
if (!$user->isLoggedIn()) {
    echo json_encode(['success' => false, 'error' => 'Unauthorized access']);
    exit;
}

// Get search parameters
$search = trim($_GET['search'] ?? '');
$status = trim($_GET['status'] ?? '');

if (strlen($search) < 2) {
    echo json_encode(['success' => false, 'error' => 'Search term must be at least 2 characters']);
    exit;
}

// Get database connection
$db = Database::getInstance();
$connection = $db->getConnection();

try {
    // Build search query
    $sql = "SELECT id, username, full_name, email, phone, status 
            FROM users 
            WHERE (username LIKE ? OR full_name LIKE ? OR email LIKE ? OR phone LIKE ?)";
    
    // Add status filter if provided
    if ($status) {
        $sql .= " AND status = ?";
    }
    
    // Limit results and exclude current user
    $sql .= " AND id != ? LIMIT 10";
    
    $stmt = $connection->prepare($sql);
    
    // Create search pattern
    $searchPattern = "%{$search}%";
    
    if ($status) {
        $stmt->bind_param("sssssi", 
            $searchPattern, $searchPattern, $searchPattern, $searchPattern, 
            $status, $_SESSION['user_id']
        );
    } else {
        $stmt->bind_param("ssssi", 
            $searchPattern, $searchPattern, $searchPattern, $searchPattern, 
            $_SESSION['user_id']
        );
    }
    
    $stmt->execute();
    $users = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
    
    // Remove sensitive information
    array_walk($users, function(&$user) {
        unset($user['password']);
        // Mask email and phone for privacy
        $user['email'] = substr($user['email'], 0, 3) . '***' . strstr($user['email'], '@');
        $user['phone'] = substr($user['phone'], 0, 4) . '******';
    });
    
    echo json_encode([
        'success' => true,
        'users' => $users
    ]);

} catch (Exception $e) {
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
} 