<?php
require_once '../../config/config.php';

header('Content-Type: application/json');

$user = new User();
if (!$user->isLoggedIn() || $user->getRole() !== 'admin') {
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit;
}

$id = intval($_POST['id'] ?? 0);
$status = $_POST['status'] ?? '';
if (!in_array($status, ['approved', 'rejected'])) {
    echo json_encode(['success' => false, 'message' => 'Invalid status']);
    exit;
}

$db = Database::getInstance();
$conn = $db->getConnection();
$stmt = $conn->prepare("UPDATE withdrawals SET status = ?, processed_at = NOW() WHERE id = ?");
$stmt->bind_param("si", $status, $id);
if ($stmt->execute()) {
    // Deduct from earnings if approved
    if ($status === 'approved') {
        // 1. Get withdrawal amount and user_id
        $stmtW = $conn->prepare("SELECT user_id, amount FROM withdrawals WHERE id = ?");
        $stmtW->bind_param("i", $id);
        $stmtW->execute();
        $rowW = $stmtW->get_result()->fetch_assoc();
        $user_id = $rowW['user_id'];
        $amount_to_withdraw = floatval($rowW['amount']);

        // 2. Get all available earnings for the user, ordered oldest first
        $stmtE = $conn->prepare("SELECT id, amount FROM earnings WHERE user_id = ? AND status = 'available' ORDER BY created_at ASC");
        $stmtE->bind_param("i", $user_id);
        $stmtE->execute();
        $resultE = $stmtE->get_result();

        // 3. Mark earnings as withdrawn until the amount is covered
        while ($amount_to_withdraw > 0 && ($earning = $resultE->fetch_assoc())) {
            $earning_id = $earning['id'];
            $earning_amount = floatval($earning['amount']);
            if ($earning_amount <= $amount_to_withdraw) {
                // Withdraw the whole earning
                $stmt2 = $conn->prepare("UPDATE earnings SET status = 'withdrawn' WHERE id = ?");
                $stmt2->bind_param("i", $earning_id);
                $stmt2->execute();
                $amount_to_withdraw -= $earning_amount;
            } else {
                // Partially withdraw this earning (split record)
                // 1. Mark part as withdrawn
                $stmt2 = $conn->prepare("UPDATE earnings SET amount = ?, status = 'withdrawn' WHERE id = ?");
                $stmt2->bind_param("di", $amount_to_withdraw, $earning_id);
                $stmt2->execute();
                // 2. Insert the remaining as available
                $remaining = $earning_amount - $amount_to_withdraw;
                $stmt3 = $conn->prepare("INSERT INTO earnings (user_id, amount, earning_type, status) VALUES (?, ?, 'cash', 'available')");
                $stmt3->bind_param("id", $user_id, $remaining);
                $stmt3->execute();
                $amount_to_withdraw = 0;
            }
        }
    }
    echo json_encode(['success' => true, 'message' => 'Withdrawal updated']);
} else {
    echo json_encode(['success' => false, 'message' => 'Update failed']);
}
?> 