<?php
require_once '../../config/config.php';

$db = Database::getInstance();
$conn = $db->getConnection();

// MLM Plan per level
$mlm_plan = [
    1 => ['members' => 3, 'payout' => 250],
    2 => ['members' => 9, 'payout' => 500],
    3 => ['members' => 27, 'payout' => 1000],
    4 => ['members' => 81, 'payout' => 2000],
    5 => ['members' => 243, 'payout' => 4000],
    6 => ['members' => 729, 'payout' => 8000],
    7 => ['members' => 2187, 'payout' => 16000],
    8 => ['members' => 6561, 'payout' => 32000],
    9 => ['members' => 19683, 'payout' => 64000],
    10 => ['members' => 59049, 'payout' => 128000],
    11 => ['members' => 177147, 'payout' => 256000],
    12 => ['members' => 531441, 'payout' => 512000],
    13 => ['members' => 1594323, 'payout' => 1024000],
    14 => ['members' => 4782969, 'payout' => 2048000],
    15 => ['members' => 14348907, 'payout' => 4096000],
    16 => ['members' => 43046721, 'payout' => 8192000],
    17 => ['members' => 129140163, 'payout' => 16384000],
    18 => ['members' => 387420489, 'payout' => 32768000],
    19 => ['members' => 1162261467, 'payout' => 65536000],
    20 => ['members' => 3486784401, 'payout' => 131072000],
];

// Optionally clear old earnings (uncomment the next line for a clean slate)
// $conn->query("DELETE FROM earnings WHERE earning_type = 'cash'");

$users = $conn->query("SELECT id FROM users WHERE role = 'user'");

$fixed = 0;
while ($user = $users->fetch_assoc()) {
    $user_id = $user['id'];

    foreach ($mlm_plan as $level => $plan) {
        $downline = get_downline_at_level($conn, $user_id, $level);
        if (count($downline) >= $plan['members']) { // Use >= for robustness
            // Check if earning already exists
            $check = $conn->prepare("SELECT id FROM earnings WHERE user_id = ? AND amount = ? AND earning_type = 'cash'");
            $check->bind_param("id", $user_id, $plan['payout']);
            $check->execute();
            $check->store_result();
            if ($check->num_rows == 0) {
                // Insert earning
                $ins = $conn->prepare("INSERT INTO earnings (user_id, amount, earning_type, status) VALUES (?, ?, 'cash', 'available')");
                $ins->bind_param("id", $user_id, $plan['payout']);
                $ins->execute();
                $fixed++;
            }
        }
    }
}

echo "Fixed/added $fixed earnings records. All past earnings are now as per MLM plan.";

// Helper function to get all downline members at a specific level
function get_downline_at_level($conn, $user_id, $level) {
    $current_level = 0;
    $current_ids = [$user_id];

    while ($current_level < $level) {
        if (empty($current_ids)) return [];
        $placeholders = implode(',', array_fill(0, count($current_ids), '?'));
        $types = str_repeat('i', count($current_ids));
        $stmt = $conn->prepare("SELECT user_id FROM genealogy WHERE parent_id IN ($placeholders)");
        $stmt->bind_param($types, ...$current_ids);
        $stmt->execute();
        $result = $stmt->get_result();
        $next_ids = [];
        while ($row = $result->fetch_assoc()) {
            $next_ids[] = $row['user_id'];
        }
        $current_ids = $next_ids;
        $current_level++;
    }
    return $current_ids;
}
?>
