<?php
require_once '../config/config.php';

// Check if user is logged in and is admin
$user = new User();
if (!$user->isLoggedIn() || !$user->isAdmin()) {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'Unauthorized access']);
    exit;
}

// Get customer ID and new status
$customer_id = intval($_POST['id'] ?? 0);
$new_status = trim($_POST['status'] ?? '');

// Validate input
if (!$customer_id || !in_array($new_status, ['active', 'inactive', 'suspended'])) {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'Invalid input']);
    exit;
}

try {
    // Update user status
    $db = Database::getInstance();
    $query = "UPDATE users SET status = ?, updated_at = NOW() WHERE id = ? AND role = 'user'";
    $stmt = $db->getConnection()->prepare($query);
    $stmt->bind_param("si", $new_status, $customer_id);
    $stmt->execute();

    if ($stmt->affected_rows > 0) {
        header('Content-Type: application/json');
        echo json_encode([
            'success' => true, 
            'message' => 'Status updated successfully',
            'new_status' => $new_status
        ]);
    } else {
        header('Content-Type: application/json');
        echo json_encode(['success' => false, 'message' => 'Customer not found']);
    }
} catch (Exception $e) {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'An error occurred: ' . $e->getMessage()]);
} 