<?php
require_once '../../config/config.php';

// Check if user is logged in and is admin
$user = new User();
if (!$user->isLoggedIn() || !$user->isAdmin()) {
    header('Location: ../../index.php');
    exit;
}

// Get filter parameters
$search = $_GET['search'] ?? '';
$status = $_GET['status'] ?? '';
$page = max(1, intval($_GET['page'] ?? 1));
$limit = 10;
$offset = ($page - 1) * $limit;

// Build the base query
$db = Database::getInstance();
$baseQuery = "FROM support_tickets st 
              LEFT JOIN users u ON st.user_id = u.id 
              WHERE 1=1";

// Add search condition if provided
if ($search) {
    $search = $db->escape($search);
    $baseQuery .= " AND (st.ticket_id LIKE '%$search%' OR u.username LIKE '%$search%' OR u.full_name LIKE '%$search%')";
}

// Add status condition if provided
if ($status) {
    $status = $db->escape($status);
    $baseQuery .= " AND st.status = '$status'";
}

// Get total records for pagination
$countQuery = "SELECT COUNT(*) as total " . $baseQuery;
$totalTickets = $db->query($countQuery)->fetch_assoc()['total'];
$totalPages = ceil($totalTickets / $limit);

// Get tickets with pagination
$query = "SELECT st.*, u.username, u.full_name, 
          (SELECT COUNT(*) FROM ticket_messages WHERE ticket_id = st.id) as message_count,
          (SELECT MAX(created_at) FROM ticket_messages WHERE ticket_id = st.id) as last_message 
          " . $baseQuery . " 
          ORDER BY FIELD(st.status, 'active', 'in_process', 'created', 'closed', 'inactive', 'deleted'), 
          st.updated_at DESC 
          LIMIT $offset, $limit";
$tickets = $db->query($query);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo APP_NAME; ?> - Support Tickets</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <style>
        .sidebar {
            min-height: 100vh;
            background-color: #343a40;
            padding-top: 20px;
        }
        .sidebar a {
            color: #fff;
            padding: 10px 15px;
            display: block;
        }
        .sidebar a:hover {
            background-color: #495057;
            text-decoration: none;
        }
        .main-content {
            padding: 20px;
        }
        .status-badge {
            width: 100px;
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <div class="col-md-2 sidebar">
                <div class="text-center text-white mb-4">
                    <h4><?php echo BRAND_NAME; ?></h4>
                    <p>Admin Panel</p>
                </div>
                <a href="../dashboard.php"><i class="fas fa-tachometer-alt mr-2"></i> Dashboard</a>
                <a href="../customers.php"><i class="fas fa-users mr-2"></i> Customers</a>
                <a href="../pins/"><i class="fas fa-key mr-2"></i> PIN Management</a>
                <a href="../reports/"><i class="fas fa-chart-bar mr-2"></i> Reports</a>
                <a href="tickets.php" class="active"><i class="fas fa-headset mr-2"></i> Support</a>
                <a href="../../logout.php"><i class="fas fa-sign-out-alt mr-2"></i> Logout</a>
            </div>

            <!-- Main Content -->
            <div class="col-md-10 main-content">
                <div class="row mb-4">
                    <div class="col-md-6">
                        <h2>Support Tickets</h2>
                    </div>
                </div>

                <!-- Filters -->
                <div class="card mb-4">
                    <div class="card-body">
                        <form method="GET" class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <input type="text" class="form-control" name="search" 
                                           value="<?php echo htmlspecialchars($search); ?>" 
                                           placeholder="Search by ticket ID or customer name">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <select class="form-control" name="status">
                                        <option value="">All Status</option>
                                        <option value="created" <?php echo $status === 'created' ? 'selected' : ''; ?>>Created</option>
                                        <option value="active" <?php echo $status === 'active' ? 'selected' : ''; ?>>Active</option>
                                        <option value="in_process" <?php echo $status === 'in_process' ? 'selected' : ''; ?>>In Process</option>
                                        <option value="closed" <?php echo $status === 'closed' ? 'selected' : ''; ?>>Closed</option>
                                        <option value="inactive" <?php echo $status === 'inactive' ? 'selected' : ''; ?>>Inactive</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <button type="submit" class="btn btn-primary btn-block">Filter</button>
                            </div>
                            <div class="col-md-2">
                                <a href="tickets.php" class="btn btn-secondary btn-block">Reset</a>
                            </div>
                        </form>
                    </div>
                </div>

                <!-- Tickets Table -->
                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>Ticket ID</th>
                                        <th>Customer</th>
                                        <th>Subject</th>
                                        <th>Status</th>
                                        <th>Messages</th>
                                        <th>Last Update</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if ($tickets->num_rows === 0): ?>
                                    <tr>
                                        <td colspan="7" class="text-center">No tickets found</td>
                                    </tr>
                                    <?php else: ?>
                                        <?php while ($row = $tickets->fetch_assoc()): ?>
                                        <tr>
                                            <td><?php echo htmlspecialchars($row['ticket_id']); ?></td>
                                            <td>
                                                <?php echo htmlspecialchars($row['username']); ?>
                                                <br>
                                                <small class="text-muted"><?php echo htmlspecialchars($row['full_name']); ?></small>
                                            </td>
                                            <td><?php echo htmlspecialchars($row['subject']); ?></td>
                                            <td>
                                                <?php
                                                $statusClass = [
                                                    'created' => 'secondary',
                                                    'active' => 'success',
                                                    'in_process' => 'primary',
                                                    'closed' => 'dark',
                                                    'inactive' => 'warning',
                                                    'deleted' => 'danger'
                                                ][$row['status']];
                                                ?>
                                                <span class="badge badge-<?php echo $statusClass; ?> status-badge">
                                                    <?php echo ucfirst(str_replace('_', ' ', $row['status'])); ?>
                                                </span>
                                            </td>
                                            <td>
                                                <?php echo number_format($row['message_count']); ?>
                                                <?php if ($row['message_count'] > 0): ?>
                                                    <br>
                                                    <small class="text-muted">
                                                        Last: <?php echo date('M d, H:i', strtotime($row['last_message'])); ?>
                                                    </small>
                                                <?php endif; ?>
                                            </td>
                                            <td><?php echo date('M d, Y H:i', strtotime($row['updated_at'])); ?></td>
                                            <td>
                                                <div class="btn-group">
                                                    <a href="chat.php?id=<?php echo $row['id']; ?>" 
                                                       class="btn btn-sm btn-info" title="View Chat">
                                                        <i class="fas fa-comments"></i>
                                                    </a>
                                                    <button type="button" 
                                                            class="btn btn-sm btn-primary" 
                                                            onclick="updateStatus(<?php echo $row['id']; ?>, '<?php echo $row['status']; ?>')"
                                                            title="Update Status">
                                                        <i class="fas fa-sync-alt"></i>
                                                    </button>
                                                </div>
                                            </td>
                                        </tr>
                                        <?php endwhile; ?>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>

                        <!-- Pagination -->
                        <?php if ($totalPages > 1): ?>
                        <nav aria-label="Page navigation" class="mt-4">
                            <ul class="pagination justify-content-center">
                                <?php if ($page > 1): ?>
                                <li class="page-item">
                                    <a class="page-link" href="?page=<?php echo ($page - 1); ?>&search=<?php echo urlencode($search); ?>&status=<?php echo urlencode($status); ?>">
                                        Previous
                                    </a>
                                </li>
                                <?php endif; ?>
                                
                                <?php for ($i = 1; $i <= $totalPages; $i++): ?>
                                <li class="page-item <?php echo $i === $page ? 'active' : ''; ?>">
                                    <a class="page-link" href="?page=<?php echo $i; ?>&search=<?php echo urlencode($search); ?>&status=<?php echo urlencode($status); ?>">
                                        <?php echo $i; ?>
                                    </a>
                                </li>
                                <?php endfor; ?>
                                
                                <?php if ($page < $totalPages): ?>
                                <li class="page-item">
                                    <a class="page-link" href="?page=<?php echo ($page + 1); ?>&search=<?php echo urlencode($search); ?>&status=<?php echo urlencode($status); ?>">
                                        Next
                                    </a>
                                </li>
                                <?php endif; ?>
                            </ul>
                        </nav>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Status Update Modal -->
    <div class="modal fade" id="statusModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Update Ticket Status</h5>
                    <button type="button" class="close" data-dismiss="modal">
                        <span>&times;</span>
                    </button>
                </div>
                <form id="updateStatusForm">
                    <div class="modal-body">
                        <input type="hidden" id="ticketId" name="ticket_id">
                        <div class="form-group">
                            <label>New Status</label>
                            <select class="form-control" name="status" id="newStatus">
                                <option value="created">Created</option>
                                <option value="active">Active</option>
                                <option value="in_process">In Process</option>
                                <option value="closed">Closed</option>
                                <option value="inactive">Inactive</option>
                            </select>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-primary">Update Status</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.5.2/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        function updateStatus(ticketId, currentStatus) {
            $('#ticketId').val(ticketId);
            $('#newStatus').val(currentStatus);
            $('#statusModal').modal('show');
        }

        $('#updateStatusForm').on('submit', function(e) {
            e.preventDefault();
            
            $.ajax({
                url: '../api/update_ticket_status.php',
                type: 'POST',
                data: $(this).serialize(),
                dataType: 'json',
                success: function(response) {
                    if (response.success) {
                        location.reload();
                    } else {
                        alert(response.error || 'Failed to update ticket status');
                    }
                },
                error: function() {
                    alert('An error occurred while updating the ticket status');
                }
            });
        });
    </script>
</body>
</html> 