<?php
require_once '../../config/config.php';

// Enable error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Set content type to JSON
header('Content-Type: application/json');

// Check if user is logged in and is admin
$user = new User();
if (!$user->isLoggedIn() || !$user->isAdmin()) {
    echo json_encode([]);
    exit;
}

// Get search term
$search = isset($_GET['search']) ? trim($_GET['search']) : '';

// Validate search term length
if (strlen($search) < 3) {
    echo json_encode([]);
    exit;
}

try {
    // Get database connection
    $db = Database::getInstance();
    $connection = $db->getConnection();

    // Prepare search query
    $query = "SELECT id, username, full_name 
              FROM users 
              WHERE role = 'user' 
              AND (
                  username LIKE ? 
                  OR full_name LIKE ? 
                  OR phone LIKE ? 
                  OR email LIKE ?
              )
              ORDER BY username
              LIMIT 10";

    $searchTerm = "%$search%";
    $stmt = $connection->prepare($query);
    $stmt->bind_param('ssss', $searchTerm, $searchTerm, $searchTerm, $searchTerm);
    $stmt->execute();
    $result = $stmt->get_result();

    // Fetch results
    $users = [];
    while ($row = $result->fetch_assoc()) {
        $users[] = [
            'id' => $row['id'],
            'username' => $row['username'],
            'full_name' => $row['full_name']
        ];
    }

    echo json_encode($users);

} catch (Exception $e) {
    // Log error
    error_log("Error searching users: " . $e->getMessage());
    echo json_encode([]);
} 