<?php
require_once '../../config/config.php';

// Check if user is logged in and is admin
$user = new User();
if (!$user->isLoggedIn() || !$user->isAdmin()) {
    header('Location: ../../index.php');
    exit;
}

try {
    // Get database connection
    $db = Database::getInstance();
    $connection = $db->getConnection();

    // Create ticket_status_logs table if it doesn't exist
    $sql = "CREATE TABLE IF NOT EXISTS ticket_status_logs (
        id INT PRIMARY KEY AUTO_INCREMENT,
        ticket_id INT NOT NULL,
        status ENUM('created', 'active', 'in_process', 'closed', 'inactive', 'deleted') NOT NULL,
        changed_by INT NOT NULL,
        changed_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        FOREIGN KEY (ticket_id) REFERENCES support_tickets(id),
        FOREIGN KEY (changed_by) REFERENCES users(id)
    )";

    if ($connection->query($sql)) {
        echo "Table 'ticket_status_logs' created successfully or already exists.<br>";
        
        // Add initial status logs for existing tickets
        $query = "INSERT INTO ticket_status_logs (ticket_id, status, changed_by, changed_at)
                 SELECT id, status, user_id, created_at
                 FROM support_tickets st
                 WHERE NOT EXISTS (
                     SELECT 1 
                     FROM ticket_status_logs tsl 
                     WHERE tsl.ticket_id = st.id
                 )";
        
        if ($connection->query($query)) {
            echo "Initial status logs added for existing tickets.<br>";
        } else {
            echo "Error adding initial status logs: " . $connection->error . "<br>";
        }
    } else {
        echo "Error creating table: " . $connection->error . "<br>";
    }

    echo "<br><a href='index.php'>Return to Support Dashboard</a>";

} catch (Exception $e) {
    echo "Error: " . $e->getMessage();
    echo "<br><a href='index.php'>Return to Support Dashboard</a>";
} 