<?php
require_once '../../config/config.php';

// Check if user is logged in and is admin
$user = new User();
if (!$user->isLoggedIn() || !$user->isAdmin()) {
    header('Location: ../../index.php');
    exit;
}

try {
    $db = Database::getInstance();
    $connection = $db->getConnection();

    // Create ticket_status_logs table if it doesn't exist
    $sql = "CREATE TABLE IF NOT EXISTS ticket_status_logs (
        id INT PRIMARY KEY AUTO_INCREMENT,
        ticket_id INT NOT NULL,
        status ENUM('created', 'active', 'in_process', 'closed', 'inactive', 'deleted') NOT NULL,
        changed_by INT NOT NULL,
        changed_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        FOREIGN KEY (ticket_id) REFERENCES support_tickets(id),
        FOREIGN KEY (changed_by) REFERENCES users(id)
    )";

    if (!$connection->query($sql)) {
        throw new Exception("Error creating table: " . $connection->error);
    }

    // Get all tickets that don't have a status log entry
    $sql = "SELECT st.id, st.status, st.created_at 
            FROM support_tickets st 
            LEFT JOIN ticket_status_logs tsl ON st.id = tsl.ticket_id 
            WHERE tsl.id IS NULL";
    
    $result = $connection->query($sql);
    
    if (!$result) {
        throw new Exception("Error fetching tickets: " . $connection->error);
    }

    // Start transaction for inserting initial status logs
    $connection->begin_transaction();

    try {
        $stmt = $connection->prepare("INSERT INTO ticket_status_logs (ticket_id, status, changed_by, changed_at) VALUES (?, ?, ?, ?)");
        
        while ($ticket = $result->fetch_assoc()) {
            $stmt->bind_param('isis', 
                $ticket['id'],
                $ticket['status'],
                $user->getId(),
                $ticket['created_at']
            );
            
            if (!$stmt->execute()) {
                throw new Exception("Error inserting status log: " . $stmt->error);
            }
        }

        $connection->commit();
        echo "Successfully created table and initialized status logs.";

    } catch (Exception $e) {
        $connection->rollback();
        throw $e;
    }

} catch (Exception $e) {
    echo "Error: " . $e->getMessage();
    error_log("Error in create_status_logs_table.php: " . $e->getMessage());
} 