<?php
require_once '../../config/config.php';

// Check admin login
$user = new User();
if (!$user->isLoggedIn() || $user->getRole() !== 'admin') {
    header('Location: ../../index.php');
    exit;
}

$db = Database::getInstance();
$conn = $db->getConnection();

// Fetch all withdrawals
$sql = "SELECT w.id, u.username, u.full_name, w.amount, w.status, w.created_at
        FROM withdrawals w
        JOIN users u ON w.user_id = u.id
        ORDER BY w.created_at DESC";
$result = $conn->query($sql);
$withdrawals = $result ? $result->fetch_all(MYSQLI_ASSOC) : [];

include_once '../../includes/header.php';
?>
<div class="container-fluid">
    <h1 class="mt-4 mb-4">Withdrawals Report</h1>
    <div class="table-responsive">
        <table class="table table-bordered table-striped">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Username</th>
                    <th>Full Name</th>
                    <th>Amount</th>
                    <th>Status</th>
                    <th>Requested At</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php if (empty($withdrawals)): ?>
                <tr><td colspan="7" class="text-center">No withdrawals found</td></tr>
                <?php else: ?>
                <?php foreach ($withdrawals as $w): ?>
                <tr id="row-<?php echo $w['id']; ?>">
                    <td><?php echo $w['id']; ?></td>
                    <td><?php echo htmlspecialchars($w['username']); ?></td>
                    <td><?php echo htmlspecialchars($w['full_name']); ?></td>
                    <td>₹<?php echo number_format($w['amount'], 2); ?></td>
                    <td><span class="badge bg-<?php
                        echo $w['status'] === 'pending' ? 'warning' : ($w['status'] === 'approved' ? 'success' : 'danger');
                    ?>"><?php echo ucfirst($w['status']); ?></span></td>
                    <td><?php echo date('Y-m-d H:i', strtotime($w['created_at'])); ?></td>
                    <td>
                        <?php if ($w['status'] === 'pending'): ?>
                        <button class="btn btn-success btn-sm" onclick="updateWithdrawal(<?php echo $w['id']; ?>, 'approved')">Approve</button>
                        <button class="btn btn-danger btn-sm" onclick="updateWithdrawal(<?php echo $w['id']; ?>, 'rejected')">Reject</button>
                        <?php else: ?>
                        -
                        <?php endif; ?>
                    </td>
                </tr>
                <?php endforeach; ?>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>
<script>
function updateWithdrawal(id, status) {
    if (!confirm('Are you sure you want to ' + status + ' this withdrawal?')) return;
    fetch('../withdrawals/update.php', {
        method: 'POST',
        headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
        body: 'id=' + encodeURIComponent(id) + '&status=' + encodeURIComponent(status)
    })
    .then(res => res.json())
    .then(data => {
        if (data.success) {
            document.querySelector('#row-' + id + ' td:nth-child(5) span').className = 'badge bg-' + (status === 'approved' ? 'success' : 'danger');
            document.querySelector('#row-' + id + ' td:nth-child(5) span').textContent = status.charAt(0).toUpperCase() + status.slice(1);
            document.querySelector('#row-' + id + ' td:nth-child(7)').innerHTML = '-';
            alert('Withdrawal ' + status + ' successfully!');
        } else {
            alert(data.message || 'Failed to update withdrawal');
        }
    })
    .catch(() => alert('Error updating withdrawal'));
}
</script>
<?php include_once '../../includes/footer.php'; ?> 