<?php
require_once '../../config/config.php';

// Check if user is logged in and is admin
$user = new User();
if (!$user->isLoggedIn() || !$user->isAdmin()) {
    header('Location: ../../index.php');
    exit;
}

// Get parameters
$report_type = $_GET['type'] ?? 'customers';
$start_date = $_GET['start_date'] ?? date('Y-m-d', strtotime('-30 days'));
$end_date = $_GET['end_date'] ?? date('Y-m-d');
$search = trim($_GET['search'] ?? '');

// Initialize database connection
$db = Database::getInstance();
$connection = $db->getConnection();

// Build query based on report type
switch ($report_type) {
    case 'earnings':
        $query = "SELECT 
                    u.username,
                    u.full_name,
                    e.amount,
                    e.earning_type,
                    e.status,
                    DATE_FORMAT(e.created_at, '%Y-%m-%d %H:%i') as date
                 FROM earnings e 
                 JOIN users u ON e.user_id = u.id 
                 WHERE e.created_at BETWEEN ? AND ?";
        if ($search) {
            $query .= " AND (u.username LIKE ? OR u.full_name LIKE ?)";
            $params = [$start_date, $end_date, "%$search%", "%$search%"];
            $types = "ssss";
        } else {
            $params = [$start_date, $end_date];
            $types = "ss";
        }
        $headers = ['Username', 'Full Name', 'Amount', 'Type', 'Status', 'Date'];
        $filename = 'earnings_report_' . date('Y-m-d') . '.csv';
        break;

    case 'withdrawals':
        $query = "SELECT 
                    u.username,
                    u.full_name,
                    w.amount,
                    w.status,
                    DATE_FORMAT(w.created_at, '%Y-%m-%d %H:%i') as requested_date,
                    DATE_FORMAT(w.processed_at, '%Y-%m-%d %H:%i') as processed_date
                 FROM withdrawals w 
                 JOIN users u ON w.user_id = u.id 
                 WHERE w.created_at BETWEEN ? AND ?";
        if ($search) {
            $query .= " AND (u.username LIKE ? OR u.full_name LIKE ?)";
            $params = [$start_date, $end_date, "%$search%", "%$search%"];
            $types = "ssss";
        } else {
            $params = [$start_date, $end_date];
            $types = "ss";
        }
        $headers = ['Username', 'Full Name', 'Amount', 'Status', 'Requested Date', 'Processed Date'];
        $filename = 'withdrawals_report_' . date('Y-m-d') . '.csv';
        break;

    default: // customers
        $query = "SELECT 
                    u.username,
                    u.full_name,
                    u.email,
                    u.phone,
                    u.status,
                    up.kyc_status,
                    DATE_FORMAT(u.created_at, '%Y-%m-%d %H:%i') as registered_date
                 FROM users u 
                 LEFT JOIN user_profiles up ON u.id = up.user_id 
                 WHERE u.role = 'user'";
        if ($search) {
            $query .= " AND (u.username LIKE ? OR u.full_name LIKE ? OR u.email LIKE ?)";
            $params = ["%$search%", "%$search%", "%$search%"];
            $types = "sss";
        } else {
            $params = [];
            $types = "";
        }
        $headers = ['Username', 'Full Name', 'Email', 'Phone', 'Status', 'KYC Status', 'Registered Date'];
        $filename = 'customers_report_' . date('Y-m-d') . '.csv';
}

// Prepare and execute query
$stmt = $connection->prepare($query);
if (!empty($params)) {
    $stmt->bind_param($types, ...$params);
}
$stmt->execute();
$result = $stmt->get_result();

// Set headers for CSV download
header('Content-Type: text/csv');
header('Content-Disposition: attachment; filename="' . $filename . '"');

// Create a file pointer connected to PHP output
$output = fopen('php://output', 'w');

// Add UTF-8 BOM for proper Excel display
fprintf($output, chr(0xEF).chr(0xBB).chr(0xBF));

// Output headers
fputcsv($output, $headers);

// Output data rows
while ($row = $result->fetch_assoc()) {
    // Clean and format data
    foreach ($row as &$value) {
        // Handle null values
        if ($value === null) {
            $value = '-';
        }
        // Format amount values
        if (is_numeric($value) && strpos($query, 'amount') !== false) {
            $value = number_format($value, 2);
        }
        // Clean special characters
        $value = str_replace(["\r", "\n"], ' ', $value);
    }
    fputcsv($output, $row);
}

// Close the file pointer
fclose($output); 