<?php
require_once '../../config/config.php';

// Enable error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Set content type to JSON
header('Content-Type: application/json');

// Check if user is logged in
$user = new User();
if (!$user->isLoggedIn()) {
    echo json_encode(['success' => false, 'message' => 'Unauthorized access']);
    exit;
}

try {
    $db = Database::getInstance();
    $connection = $db->getConnection();
    
    // Get available PINs for the current user
    $query = "SELECT id, pin_number as pin_code, created_at 
              FROM pins 
              WHERE current_owner = ? 
              AND status = 'created' 
              ORDER BY created_at DESC";
              
    $stmt = $connection->prepare($query);
    if (!$stmt) {
        throw new Exception("Failed to prepare pins query: " . $connection->error);
    }
    
    $currentUserId = $user->getId();
    $stmt->bind_param("i", $currentUserId);
    
    if (!$stmt->execute()) {
        throw new Exception("Failed to execute pins query: " . $stmt->error);
    }
    
    $result = $stmt->get_result();
    $pins = [];
    
    while ($row = $result->fetch_assoc()) {
        $pins[] = [
            'id' => $row['id'],
            'pin_code' => $row['pin_code'],
            'created_at' => date('Y-m-d H:i:s', strtotime($row['created_at']))
        ];
    }
    
    echo json_encode([
        'success' => true,
        'pins' => $pins
    ]);

} catch (Exception $e) {
    error_log("Get Available PINs Error: " . $e->getMessage());
    
    echo json_encode([
        'success' => false,
        'message' => 'An error occurred while retrieving available PINs',
        'pins' => []
    ]);
} 