<?php
require_once '../../config/config.php';

// Check if user is logged in and is admin
$user = new User();
if (!$user->isLoggedIn() || !$user->isAdmin()) {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'Unauthorized access']);
    exit;
}

// Get the PIN to expire
$pin = trim($_POST['pin'] ?? '');

// Validate input
if (empty($pin)) {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'PIN is required']);
    exit;
}

try {
    $db = Database::getInstance();

    // Check if PIN exists and is in created status
    $checkQuery = "SELECT status FROM pins WHERE pin_number = ?";
    $stmt = $db->getConnection()->prepare($checkQuery);
    $stmt->bind_param("s", $pin);
    $stmt->execute();
    $result = $stmt->get_result()->fetch_assoc();

    if (!$result) {
        header('Content-Type: application/json');
        echo json_encode(['success' => false, 'message' => 'PIN not found']);
        exit;
    }

    if ($result['status'] !== 'created') {
        header('Content-Type: application/json');
        echo json_encode(['success' => false, 'message' => 'PIN is already ' . $result['status']]);
        exit;
    }

    // Update PIN status to expired
    $updateQuery = "UPDATE pins SET status = 'expired', updated_at = NOW() WHERE pin_number = ?";
    $stmt = $db->getConnection()->prepare($updateQuery);
    $stmt->bind_param("s", $pin);
    $stmt->execute();

    if ($stmt->affected_rows > 0) {
        header('Content-Type: application/json');
        echo json_encode(['success' => true, 'message' => 'PIN expired successfully']);
    } else {
        header('Content-Type: application/json');
        echo json_encode(['success' => false, 'message' => 'Failed to expire PIN']);
    }

} catch (Exception $e) {
    header('Content-Type: application/json');
    echo json_encode([
        'success' => false,
        'message' => 'An error occurred while expiring the PIN: ' . $e->getMessage()
    ]);
} 