<?php
require_once '../config/config.php';

// Check if user is logged in and is admin
$user = new User();
if (!$user->isLoggedIn() || !$user->isAdmin()) {
    header('Location: ../index.php');
    exit;
}

$db = Database::getInstance();

// Handle search
$search_username = isset($_GET['username']) ? trim($_GET['username']) : '';
$searched_user = null;
$tree = [];
$error = '';

function getUserById($db, $user_id) {
    $sql = "SELECT id, username, full_name, status FROM users WHERE id = $user_id";
    $res = $db->query($sql);
    return $res && $res->num_rows ? $res->fetch_assoc() : null;
}

function getDownlineCount($db, $user_id) {
    $sql = "SELECT COUNT(*) as cnt FROM genealogy WHERE parent_id = $user_id";
    $res = $db->query($sql);
    return $res ? (int)$res->fetch_assoc()['cnt'] : 0;
}

function getChildren($db, $user_id) {
    $sql = "SELECT user_id FROM genealogy WHERE parent_id = $user_id ORDER BY position ASC";
    $res = $db->query($sql);
    $children = [];
    if ($res) {
        while ($row = $res->fetch_assoc()) {
            $children[] = $row['user_id'];
        }
    }
    return $children;
}

function getDirectReferrals($db, $user_id) {
    $sql = "SELECT u.id, u.username, u.full_name, u.status, g.created_at, g.placement_level, g.position FROM genealogy g JOIN users u ON g.user_id = u.id WHERE g.parent_id = $user_id ORDER BY g.placement_level, g.position";
    $res = $db->query($sql);
    $refs = [];
    if ($res) {
        while ($row = $res->fetch_assoc()) {
            $refs[] = $row;
        }
    }
    return $refs;
}

if ($search_username !== '') {
    $safe_username = $db->escape($search_username);
    $sql = "SELECT id, username, full_name, status FROM users WHERE username = '$safe_username' LIMIT 1";
    $res = $db->query($sql);
    if ($res && $res->num_rows) {
        $searched_user = $res->fetch_assoc();
        $tree = [];
        $level1 = getDirectReferrals($db, $searched_user['id']);
        foreach ($level1 as $ref1) {
            $level2 = getDirectReferrals($db, $ref1['id']);
            $tree[] = [
                'user' => $ref1,
                'children' => $level2
            ];
        }
    } else {
        $error = 'User not found.';
    }
}

// Recursive function to fetch genealogy tree
function fetchGenealogyTree($db, $user_id, $max_depth = 3, $current_depth = 1) {
    if ($current_depth > $max_depth) return [];
    $sql = "SELECT u.id, u.username, u.full_name, u.status FROM genealogy g JOIN users u ON g.user_id = u.id WHERE g.parent_id = ? ORDER BY g.position";
    $stmt = $db->getConnection()->prepare($sql);
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $children = [];
    $res = $stmt->get_result();
    while ($row = $res->fetch_assoc()) {
        $row['children'] = fetchGenealogyTree($db, $row['id'], $max_depth, $current_depth + 1);
        $children[] = $row;
    }
    return $children;
}

// Recursive function to render the tree
function renderGenealogyTree($user, $children) {
    ?>
    <li>
        <div class="tree-node">
            <img src="../assets/images/avatar.png" class="avatar" alt="avatar">
            <div class="username"><?php echo htmlspecialchars($user['username']); ?></div>
        </div>
        <?php if (!empty($children)): ?>
        <ul>
            <?php foreach ($children as $child): ?>
                <?php renderGenealogyTree($child, $child['children']); ?>
            <?php endforeach; ?>
        </ul>
        <?php endif; ?>
    </li>
    <?php
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo APP_NAME; ?> - Genealogy</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <style>
        .sidebar {
            min-height: 100vh;
            background: linear-gradient(180deg, #3a86ff 0%, #8338ec 100%);
            padding-top: 20px;
            border-top-right-radius: 20px;
            border-bottom-right-radius: 20px;
            box-shadow: 2px 0 12px rgba(51,51,51,0.08);
            transition: background 0.3s;
        }
        .sidebar .sidebar-brand {
            display: flex;
            flex-direction: column;
            align-items: center;
            margin-bottom: 2rem;
        }
        .sidebar .sidebar-logo {
            width: 60px;
            height: 60px;
            border-radius: 50%;
            background: #fff;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-bottom: 0.5rem;
            box-shadow: 0 2px 8px rgba(0,0,0,0.08);
        }
        .sidebar .sidebar-logo i {
            font-size: 2rem;
            color: #3a86ff;
        }
        .sidebar .sidebar-title {
            color: #fff;
            font-weight: bold;
            font-size: 1.2rem;
            letter-spacing: 1px;
        }
        .sidebar-section {
            color: #e0e1dd;
            font-size: 0.85rem;
            text-transform: uppercase;
            margin: 1.5rem 0 0.5rem 1rem;
            letter-spacing: 0.08em;
        }
        .sidebar a {
            color: #fff;
            padding: 12px 22px;
            display: flex;
            align-items: center;
            border-radius: 8px 0 0 8px;
            margin-bottom: 6px;
            font-size: 1.05rem;
            transition: background 0.2s, color 0.2s, box-shadow 0.2s;
        }
        .sidebar a.active, .sidebar a:hover {
            background: rgba(255, 255, 255, 0.15);
            color: #ffbe0b;
            box-shadow: 2px 2px 8px rgba(0,0,0,0.07);
            font-weight: bold;
        }
        .sidebar a i {
            margin-right: 12px;
            font-size: 1.2em;
        }
        @media (max-width: 767.98px) {
            .sidebar {
                position: fixed;
                z-index: 1050;
                left: 0;
                top: 0;
                width: 220px;
                height: 100vh;
                transform: translateX(-100%);
                transition: transform 0.3s ease;
                border-radius: 0 20px 20px 0;
            }
            .sidebar.collapse.show {
                transform: translateX(0);
            }
            .main-content {
                padding: 10px;
            }
        }
        .main-content {
            padding: 20px;
        }
        ul.genealogy-tree, ul.genealogy-tree ul {
            list-style: none;
            padding-left: 30px;
        }
        ul.genealogy-tree > li {
            margin-bottom: 10px;
        }
        .genealogy-tree, .genealogy-tree ul {
            padding-top: 20px; position: relative;
            display: flex; justify-content: center;
            list-style: none;
        }
        .genealogy-tree ul { padding-top: 40px; }
        .genealogy-tree li {
            text-align: center;
            position: relative;
            padding: 20px 5px 0 5px;
        }
        .genealogy-tree li::before, .genealogy-tree li::after {
            content: '';
            position: absolute; top: 0; right: 50%;
            border-top: 2px solid #ccc; width: 50%; height: 20px;
        }
        .genealogy-tree li::after {
            right: auto; left: 50%; border-left: 2px solid #ccc;
        }
        .genealogy-tree li:only-child::before, .genealogy-tree li:only-child::after {
            display: none;
        }
        .genealogy-tree li:only-child { padding-top: 0; }
        .genealogy-tree li:first-child::before, .genealogy-tree li:last-child::after {
            border: 0 none;
        }
        .tree-node {
            display: flex; flex-direction: column; align-items: center;
        }
        .avatar {
            width: 60px; height: 60px; border-radius: 50%; border: 2px solid #6c63ff;
            background: #fff;
        }
        .username {
            margin-top: 8px; font-weight: bold; color: #6c63ff;
            background: #f3f0ff; padding: 2px 8px; border-radius: 6px;
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar Overlay (for mobile) -->
            <div id="sidebarOverlay" style="display:none;position:fixed;top:0;left:0;width:100vw;height:100vh;background:rgba(0,0,0,0.3);z-index:1049;"></div>
            <!-- Sidebar Toggle Button (visible on mobile) -->
            <button class="btn btn-dark d-md-none m-2" type="button" data-toggle="collapse" data-target="#adminSidebar" aria-controls="adminSidebar" aria-expanded="false" aria-label="Toggle navigation">
                <i class="fas fa-bars"></i> Menu
            </button>
            <!-- Sidebar -->
            <nav id="adminSidebar" class="col-md-2 sidebar collapse d-md-block">
                <div class="sidebar-brand">
                    <div class="sidebar-logo">
                        <i class="fas fa-user-shield"></i>
                    </div>
                    <div class="sidebar-title"><?php echo BRAND_NAME; ?></div>
                    <div style="color:#e0e1dd;font-size:0.9em;">Admin Panel</div>
                </div>
                <div class="sidebar-section">Main</div>
                <a href="dashboard.php"><i class="fas fa-tachometer-alt"></i> Dashboard</a>
                <div class="sidebar-section">Customers</div>
                <a href="customers.php"><i class="fas fa-users"></i> Customers</a>
                <a href="cus-products.php"><i class="fas fa-users"></i> Customers Products</a>
                <div class="sidebar-section">Management</div>
                <a href="pins/"><i class="fas fa-key"></i> PIN Management</a>
                <a href="genealogy.php" class="active"><i class="fas fa-sitemap"></i> Genealogy</a>
                <a href="reports/"><i class="fas fa-chart-bar"></i> Reports</a>
                <div class="sidebar-section">Support</div>
                <a href="support/"><i class="fas fa-headset"></i> Support</a>
                <a href="../logout.php"><i class="fas fa-sign-out-alt"></i> Logout</a>
            </nav>
            <!-- Main Content -->
            <div class="col-md-10 main-content">
                <div class="row mb-4">
                    <div class="col-md-8">
                        <h2>Genealogy Tree (Up to 2 Levels)</h2>
                    </div>
                </div>
                <div class="card mb-4">
                    <div class="card-body">
                        <form method="GET" class="form-inline">
                            <div class="form-group mb-2 mr-2">
                                <input type="text" class="form-control" name="username" placeholder="Enter Username" value="<?php echo htmlspecialchars($search_username); ?>" required>
                            </div>
                            <button type="submit" class="btn btn-primary mb-2">Search</button>
                        </form>
                        <?php if ($error): ?>
                            <div class="alert alert-danger mt-3"><?php echo $error; ?></div>
                        <?php endif; ?>
                    </div>
                </div>
                <?php if ($searched_user && !$error): ?>
                <div class="card">
                    <div class="card-body">
                        <h5>Genealogy Tree for <strong><?php echo htmlspecialchars($searched_user['username']); ?></strong></h5>
                        <ul class="genealogy-tree">
                            <?php if ($searched_user): ?>
                                <li>
                                    <div class="tree-node">
                                        <img src="../assets/images/avatar.png" class="avatar" alt="avatar">
                                        <div class="username"><?php echo htmlspecialchars($searched_user['username']); ?></div>
                                    </div>
                                    <?php
                                    $children = fetchGenealogyTree($db, $searched_user['id']);
                                    if (!empty($children)): ?>
                                        <ul>
                                            <?php foreach ($children as $child): ?>
                                                <?php renderGenealogyTree($child, $child['children']); ?>
                                            <?php endforeach; ?>
                                        </ul>
                                    <?php endif; ?>
                                </li>
                            <?php endif; ?>
                        </ul>
                        <?php if ($searched_user && empty(fetchGenealogyTree($db, $searched_user['id']))): ?>
                            <div class="alert alert-warning mt-3">No downline members found for this user.</div>
                        <?php endif; ?>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.5.2/dist/js/bootstrap.bundle.min.js"></script>
    <script>
    $(function() {
        var sidebar = $('#adminSidebar');
        var overlay = $('#sidebarOverlay');
        sidebar.on('show.bs.collapse', function() {
            if (window.innerWidth < 768) overlay.show();
        });
        sidebar.on('hide.bs.collapse', function() {
            overlay.hide();
        });
        overlay.on('click', function() {
            sidebar.collapse('hide');
        });
        $(window).on('resize', function() {
            if (window.innerWidth >= 768) overlay.hide();
        });
    });
    </script>
</body>
</html>
