<?php
require_once '../config/config.php';

// Check if user is logged in and is admin
$user = new User();
if (!$user->isLoggedIn() || !$user->isAdmin()) {
    header('Location: ../index.php');
    exit;
}

$userData = $user->getCurrentUser();

// Get live statistics
$db = Database::getInstance();
$conn = $db->getConnection();
// Total Users
$totalUsers = $conn->query("SELECT COUNT(*) as total FROM users WHERE role = 'user'")->fetch_assoc()['total'];
// Available PINs
$availablePins = $conn->query("SELECT COUNT(*) as total FROM pins WHERE status = 'created'")->fetch_assoc()['total'];
// Open Tickets
$openTickets = $conn->query("SELECT COUNT(*) as total FROM support_tickets WHERE status IN ('created', 'active', 'in_process')")->fetch_assoc()['total'];
// Total Earnings
$totalEarnings = $conn->query("SELECT SUM(amount) as total FROM earnings")->fetch_assoc()['total'] ?? 0;
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo APP_NAME; ?> - Admin Dashboard</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <style>
        .sidebar {
            min-height: 100vh;
            background: linear-gradient(180deg, #3a86ff 0%, #8338ec 100%);
            padding-top: 20px;
            border-top-right-radius: 20px;
            border-bottom-right-radius: 20px;
            box-shadow: 2px 0 12px rgba(51,51,51,0.08);
            transition: background 0.3s;
        }
        .sidebar .sidebar-brand {
            display: flex;
            flex-direction: column;
            align-items: center;
            margin-bottom: 2rem;
        }
        .sidebar .sidebar-logo {
            width: 60px;
            height: 60px;
            border-radius: 50%;
            background: #fff;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-bottom: 0.5rem;
            box-shadow: 0 2px 8px rgba(0,0,0,0.08);
        }
        .sidebar .sidebar-logo i {
            font-size: 2rem;
            color: #3a86ff;
        }
        .sidebar .sidebar-title {
            color: #fff;
            font-weight: bold;
            font-size: 1.2rem;
            letter-spacing: 1px;
        }
        .sidebar-section {
            color: #e0e1dd;
            font-size: 0.85rem;
            text-transform: uppercase;
            margin: 1.5rem 0 0.5rem 1rem;
            letter-spacing: 0.08em;
        }
        .sidebar a {
            color: #fff;
            padding: 12px 22px;
            display: flex;
            align-items: center;
            border-radius: 8px 0 0 8px;
            margin-bottom: 6px;
            font-size: 1.05rem;
            transition: background 0.2s, color 0.2s, box-shadow 0.2s;
        }
        .sidebar a.active, .sidebar a:hover {
            background: rgba(255, 255, 255, 0.15);
            color: #ffbe0b;
            box-shadow: 2px 2px 8px rgba(0,0,0,0.07);
            font-weight: bold;
        }
        .sidebar a i {
            margin-right: 12px;
            font-size: 1.2em;
        }
        @media (max-width: 767.98px) {
            .sidebar {
                position: fixed;
                z-index: 1050;
                left: 0;
                top: 0;
                width: 220px;
                height: 100vh;
                transform: translateX(-100%);
                transition: transform 0.3s ease;
                border-radius: 0 20px 20px 0;
            }
            .sidebar.collapse.show {
                transform: translateX(0);
            }
            .main-content {
                padding: 10px;
            }
        }
        .main-content {
            padding: 20px;
        }
        .card-counter {
            padding: 20px;
            background-color: #fff;
            border-radius: 5px;
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
            margin-bottom: 20px;
        }
        .card-counter i {
            font-size: 4em;
            opacity: 0.3;
        }
        .card-counter .count {
            font-size: 26px;
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar Overlay (for mobile) -->
            <div id="sidebarOverlay" style="display:none;position:fixed;top:0;left:0;width:100vw;height:100vh;background:rgba(0,0,0,0.3);z-index:1049;"></div>
            <!-- Sidebar Toggle Button (visible on mobile) -->
            <button class="btn btn-dark d-md-none m-2" type="button" data-toggle="collapse" data-target="#adminSidebar" aria-controls="adminSidebar" aria-expanded="false" aria-label="Toggle navigation">
                <i class="fas fa-bars"></i> Menu
            </button>
            <!-- Sidebar -->
            <nav id="adminSidebar" class="col-md-2 sidebar collapse d-md-block">
                <div class="sidebar-brand">
                    <div class="sidebar-logo">
                        <i class="fas fa-user-shield"></i>
                    </div>
                    <div class="sidebar-title"><?php echo BRAND_NAME; ?></div>
                    <div style="color:#e0e1dd;font-size:0.9em;">Admin Panel</div>
                </div>
                <div class="sidebar-section">Main</div>
                <a href="dashboard.php"><i class="fas fa-tachometer-alt"></i> Dashboard</a>
                <div class="sidebar-section">Customers</div>
                <a href="customers.php" class="active"><i class="fas fa-users"></i> Customers</a>
                <a href="cus-products.php" class="active"><i class="fas fa-users"></i> Customers Products</a>
                <div class="sidebar-section">Management</div>
                <a href="pins/"><i class="fas fa-key"></i> PIN Management</a>
                <a href="genealogy.php"><i class="fas fa-sitemap"></i> Genealogy</a>
                <a href="reports/"><i class="fas fa-chart-bar"></i> Reports</a>
                <div class="sidebar-section">Support</div>
                <a href="support/"><i class="fas fa-headset"></i> Support</a>
                <a href="../logout.php"><i class="fas fa-sign-out-alt"></i> Logout</a>
            </nav>
            <!-- Main Content -->
            <div class="col-md-10 main-content">
                <div class="row mb-4">
                    <div class="col-md-12">
                        <h2>Welcome, <?php echo htmlspecialchars($userData['full_name']); ?></h2>
                        <p>Admin Dashboard Overview</p>
                    </div>
                </div>

                <!-- Statistics Cards -->
                <div class="row">
                    <div class="col-md-3">
                        <div class="card-counter bg-primary text-white">
                            <i class="fas fa-users float-right"></i>
                            <div class="count"><?php echo number_format($totalUsers); ?></div>
                            <span>Total Users</span>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card-counter bg-success text-white">
                            <i class="fas fa-key float-right"></i>
                            <div class="count"><?php echo number_format($availablePins); ?></div>
                            <span>Available PINs</span>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card-counter bg-warning text-white">
                            <i class="fas fa-ticket-alt float-right"></i>
                            <div class="count"><?php echo number_format($openTickets); ?></div>
                            <span>Open Tickets</span>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card-counter bg-info text-white">
                            <i class="fas fa-money-bill-wave float-right"></i>
                            <div class="count">₹<?php echo number_format($totalEarnings, 2); ?></div>
                            <span>Total Earnings</span>
                        </div>
                    </div>
                </div>

                <!-- Recent Activities -->
                <div class="row mt-4">
                    <div class="col-md-12">
                        <div class="card">
                            <div class="card-header">
                                <h5>Recent Activities</h5>
                            </div>
                            <div class="card-body">
                                <p class="text-muted">No recent activities to display.</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.5.2/dist/js/bootstrap.bundle.min.js"></script>
    <script>
    $(function() {
        var sidebar = $('#adminSidebar');
        var overlay = $('#sidebarOverlay');
        // Show overlay when sidebar is open on mobile
        sidebar.on('show.bs.collapse', function() {
            if (window.innerWidth < 768) overlay.show();
        });
        sidebar.on('hide.bs.collapse', function() {
            overlay.hide();
        });
        // Clicking overlay closes sidebar
        overlay.on('click', function() {
            sidebar.collapse('hide');
        });
        // Hide overlay on resize if sidebar is not open
        $(window).on('resize', function() {
            if (window.innerWidth >= 768) overlay.hide();
        });
    });
    </script>
</body>
</html> 