<?php
require_once '../config/config.php';

// Check if user is logged in and is admin
$user = new User();
if (!$user->isLoggedIn() || !$user->isAdmin()) {
    header('Location: ../index.php');
    exit;
}

$db = Database::getInstance();

// Filters (optional, can be expanded)
$search = isset($_GET['search']) ? trim($_GET['search']) : '';
$status = isset($_GET['status']) ? trim($_GET['status']) : '';

$where = '1=1';
if ($search !== '') {
    $safe_search = $db->escape($search);
    $where .= " AND (u.username LIKE '%$safe_search%' OR u.full_name LIKE '%$safe_search%' OR p.bill_no LIKE '%$safe_search%' OR p.description LIKE '%$safe_search%')";
}
if ($status !== '') {
    $safe_status = $db->escape($status);
    $where .= " AND p.status = '$safe_status'";
}

// Query all user product purchases
$sql = "SELECT up.purchase_date, u.username, u.full_name, p.description, p.bill_no, p.cost, p.status
        FROM user_products up
        JOIN users u ON up.user_id = u.id
        JOIN products p ON up.product_id = p.id
        WHERE $where
        ORDER BY up.purchase_date DESC";
$res = $db->query($sql);

// Handle Add Invoice form submission
$add_invoice_msg = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['add_invoice'])) {
    $user_id = intval($_POST['user_id'] ?? 0);
    $description = trim($_POST['description'] ?? '');
    $bill_no = trim($_POST['bill_no'] ?? '');
    $cost = floatval($_POST['cost'] ?? 0);
    $status = trim($_POST['status'] ?? 'active');
    if ($user_id && $description && $bill_no && $cost > 0) {
        // Check if bill_no is unique
        $stmt = $db->getConnection()->prepare("SELECT id FROM products WHERE bill_no = ?");
        $stmt->bind_param("s", $bill_no);
        $stmt->execute();
        $stmt->store_result();
        if ($stmt->num_rows > 0) {
            $add_invoice_msg = '<div class="alert alert-danger">Bill No. already exists.</div>';
        } else {
            // Insert into products
            $stmt = $db->getConnection()->prepare("INSERT INTO products (description, bill_no, cost, status) VALUES (?, ?, ?, ?)");
            $stmt->bind_param("ssds", $description, $bill_no, $cost, $status);
            if ($stmt->execute()) {
                $product_id = $db->getLastId();
                // Insert into user_products
                $stmt2 = $db->getConnection()->prepare("INSERT INTO user_products (user_id, product_id) VALUES (?, ?)");
                $stmt2->bind_param("ii", $user_id, $product_id);
                if ($stmt2->execute()) {
                    $add_invoice_msg = '<div class="alert alert-success">Invoice added successfully!</div>';
                } else {
                    $add_invoice_msg = '<div class="alert alert-danger">Failed to link product to user.</div>';
                }
            } else {
                $add_invoice_msg = '<div class="alert alert-danger">Failed to add product.</div>';
            }
        }
    } else {
        $add_invoice_msg = '<div class="alert alert-danger">All fields are required and cost must be positive.</div>';
    }
}

// Fetch all active users for dropdown
$users_res = $db->query("SELECT id, username, full_name FROM users WHERE role = 'user' AND status = 'active' ORDER BY username");
$all_users = $users_res ? $users_res->fetch_all(MYSQLI_ASSOC) : [];

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo APP_NAME; ?> - Customers Products</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <style>
        .sidebar {
            min-height: 100vh;
            background: linear-gradient(180deg, #3a86ff 0%, #8338ec 100%);
            padding-top: 20px;
            border-top-right-radius: 20px;
            border-bottom-right-radius: 20px;
            box-shadow: 2px 0 12px rgba(51,51,51,0.08);
            transition: background 0.3s;
        }
        .sidebar .sidebar-brand {
            display: flex;
            flex-direction: column;
            align-items: center;
            margin-bottom: 2rem;
        }
        .sidebar .sidebar-logo {
            width: 60px;
            height: 60px;
            border-radius: 50%;
            background: #fff;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-bottom: 0.5rem;
            box-shadow: 0 2px 8px rgba(0,0,0,0.08);
        }
        .sidebar .sidebar-logo i {
            font-size: 2rem;
            color: #3a86ff;
        }
        .sidebar .sidebar-title {
            color: #fff;
            font-weight: bold;
            font-size: 1.2rem;
            letter-spacing: 1px;
        }
        .sidebar-section {
            color: #e0e1dd;
            font-size: 0.85rem;
            text-transform: uppercase;
            margin: 1.5rem 0 0.5rem 1rem;
            letter-spacing: 0.08em;
        }
        .sidebar a {
            color: #fff;
            padding: 12px 22px;
            display: flex;
            align-items: center;
            border-radius: 8px 0 0 8px;
            margin-bottom: 6px;
            font-size: 1.05rem;
            transition: background 0.2s, color 0.2s, box-shadow 0.2s;
        }
        .sidebar a.active, .sidebar a:hover {
            background: rgba(255, 255, 255, 0.15);
            color: #ffbe0b;
            box-shadow: 2px 2px 8px rgba(0,0,0,0.07);
            font-weight: bold;
        }
        .sidebar a i {
            margin-right: 12px;
            font-size: 1.2em;
        }
        @media (max-width: 767.98px) {
            .sidebar {
                position: fixed;
                z-index: 1050;
                left: 0;
                top: 0;
                width: 220px;
                height: 100vh;
                transform: translateX(-100%);
                transition: transform 0.3s ease;
                border-radius: 0 20px 20px 0;
            }
            .sidebar.collapse.show {
                transform: translateX(0);
            }
            .main-content {
                padding: 10px;
            }
        }
        .main-content {
            padding: 20px;
        }
        .status-badge {
            width: 120px;
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar Overlay (for mobile) -->
            <div id="sidebarOverlay" style="display:none;position:fixed;top:0;left:0;width:100vw;height:100vh;background:rgba(0,0,0,0.3);z-index:1049;"></div>
            <!-- Sidebar Toggle Button (visible on mobile) -->
            <button class="btn btn-dark d-md-none m-2" type="button" data-toggle="collapse" data-target="#adminSidebar" aria-controls="adminSidebar" aria-expanded="false" aria-label="Toggle navigation">
                <i class="fas fa-bars"></i> Menu
            </button>
            <!-- Sidebar -->
            <nav id="adminSidebar" class="col-md-2 sidebar collapse d-md-block">
                <div class="sidebar-brand">
                    <div class="sidebar-logo">
                        <i class="fas fa-user-shield"></i>
                    </div>
                    <div class="sidebar-title"><?php echo BRAND_NAME; ?></div>
                    <div style="color:#e0e1dd;font-size:0.9em;">Admin Panel</div>
                </div>
                <div class="sidebar-section">Main</div>
                <a href="dashboard.php"><i class="fas fa-tachometer-alt"></i> Dashboard</a>
                <div class="sidebar-section">Customers</div>
                <a href="customers.php"><i class="fas fa-users"></i> Customers</a>
                <a href="cus-products.php" class="active"><i class="fas fa-users"></i> Customers Products</a>
                <div class="sidebar-section">Management</div>
                <a href="pins/"><i class="fas fa-key"></i> PIN Management</a>
                <a href="genealogy.php"><i class="fas fa-sitemap"></i> Genealogy</a>
                <a href="reports/"><i class="fas fa-chart-bar"></i> Reports</a>
                <div class="sidebar-section">Support</div>
                <a href="support/"><i class="fas fa-headset"></i> Support</a>
                <a href="../logout.php"><i class="fas fa-sign-out-alt"></i> Logout</a>
            </nav>
            <!-- Main Content -->
            <div class="col-md-10 main-content">
                <div class="row mb-4">
                    <div class="col-md-8">
                        <h2>Customers Product Purchases</h2>
                    </div>
                    <div class="col-md-4 text-right">
                        <button class="btn btn-primary" data-toggle="modal" data-target="#addInvoiceModal"><i class="fas fa-plus"></i> Add Invoice</button>
                    </div>
                </div>
                <?php if (!empty($add_invoice_msg)) echo $add_invoice_msg; ?>
                <!-- Filters -->
                <div class="card mb-4">
                    <div class="card-body">
                        <form method="GET" class="form-inline">
                            <div class="form-group mb-2 mr-2">
                                <input type="text" class="form-control" name="search" placeholder="Search by username, name, bill no, product" value="<?php echo htmlspecialchars($search); ?>">
                            </div>
                            <div class="form-group mb-2 mr-2">
                                <select class="form-control" name="status">
                                    <option value="">All Status</option>
                                    <option value="active" <?php echo $status === 'active' ? 'selected' : ''; ?>>Payment Withdrawn</option>
                                    <option value="withdrawn" <?php echo $status === 'withdrawn' ? 'selected' : ''; ?>>Withdrawn</option>
                                    <option value="cancelled" <?php echo $status === 'cancelled' ? 'selected' : ''; ?>>Cancelled</option>
                                    <option value="closed" <?php echo $status === 'closed' ? 'selected' : ''; ?>>Closed</option>
                                </select>
                            </div>
                            <button type="submit" class="btn btn-primary mb-2">Filter</button>
                            <a href="cus-products.php" class="btn btn-secondary mb-2 ml-2">Reset</a>
                        </form>
                    </div>
                </div>
                <!-- Purchases Table -->
                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>Purchase Date</th>
                                        <th>Username</th>
                                        <th>Full Name</th>
                                        <th>Product Description</th>
                                        <th>Bill No.</th>
                                        <th>Cost (₹)</th>
                                        <th>Status</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if ($res && $res->num_rows): ?>
                                        <?php while ($row = $res->fetch_assoc()): ?>
                                            <tr>
                                                <td><?php echo htmlspecialchars($row['purchase_date']); ?></td>
                                                <td><?php echo htmlspecialchars($row['username']); ?></td>
                                                <td><?php echo htmlspecialchars($row['full_name']); ?></td>
                                                <td><?php echo htmlspecialchars($row['description']); ?></td>
                                                <td><?php echo htmlspecialchars($row['bill_no']); ?></td>
                                                <td><?php echo number_format($row['cost'], 2); ?></td>
                                                <td>
                                                    <span class="badge <?php
                                                        switch ($row['status']) {
                                                            case 'active': echo 'badge-success'; break;
                                                            case 'withdrawn': echo 'badge-info'; break;
                                                            case 'cancelled': echo 'badge-danger'; break;
                                                            case 'closed': echo 'badge-secondary'; break;
                                                            default: echo 'badge-light';
                                                        }
                                                    ?> status-badge">
                                                        <?php
                                                        switch ($row['status']) {
                                                            case 'active': echo 'Payment Withdrawn'; break;
                                                            case 'withdrawn': echo 'Withdrawn'; break;
                                                            case 'cancelled': echo 'Cancelled'; break;
                                                            case 'closed': echo 'Closed'; break;
                                                            default: echo ucfirst($row['status']);
                                                        }
                                                        ?>
                                                    </span>
                                                </td>
                                                <td>
                                                    <?php if ($row['status'] === 'active'): ?>
                                                        <button class="btn btn-sm btn-success" disabled>Withdrawn</button>
                                                    <?php elseif ($row['status'] === 'withdrawn'): ?>
                                                        <button class="btn btn-sm btn-info" disabled>Already Withdrawn</button>
                                                    <?php elseif ($row['status'] === 'cancelled'): ?>
                                                        <button class="btn btn-sm btn-danger" disabled>Cancelled</button>
                                                    <?php elseif ($row['status'] === 'closed'): ?>
                                                        <button class="btn btn-sm btn-secondary" disabled>Closed</button>
                                                    <?php else: ?>
                                                        <button class="btn btn-sm btn-primary" disabled>Action</button>
                                                    <?php endif; ?>
                                                </td>
                                            </tr>
                                        <?php endwhile; ?>
                                    <?php else: ?>
                                        <tr><td colspan="8" class="text-center">No product purchases found.</td></tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Add Invoice Modal -->
    <div class="modal fade" id="addInvoiceModal" tabindex="-1" role="dialog" aria-labelledby="addInvoiceModalLabel" aria-hidden="true">
      <div class="modal-dialog" role="document">
        <div class="modal-content">
          <form method="POST" action="">
            <div class="modal-header">
              <h5 class="modal-title" id="addInvoiceModalLabel">Add New Invoice</h5>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
              </button>
            </div>
            <div class="modal-body">
              <div class="form-group">
                <label for="user_id">Customer</label>
                <select class="form-control" id="user_id" name="user_id" required>
                  <option value="">Select Customer</option>
                  <?php foreach ($all_users as $u): ?>
                    <option value="<?php echo $u['id']; ?>"><?php echo htmlspecialchars($u['username'] . ' - ' . $u['full_name']); ?></option>
                  <?php endforeach; ?>
                </select>
              </div>
              <div class="form-group">
                <label for="description">Product Description</label>
                <input type="text" class="form-control" id="description" name="description" required>
              </div>
              <div class="form-group">
                <label for="bill_no">Bill No.</label>
                <input type="text" class="form-control" id="bill_no" name="bill_no" required>
              </div>
              <div class="form-group">
                <label for="cost">Cost (₹)</label>
                <input type="number" step="0.01" min="0" class="form-control" id="cost" name="cost" required>
              </div>
              <div class="form-group">
                <label for="status">Status</label>
                <select class="form-control" id="status" name="status" required>
                  <option value="active">Payment Withdrawn</option>
                  <option value="withdrawn">Withdrawn</option>
                  <option value="cancelled">Cancelled</option>
                  <option value="closed">Closed</option>
                </select>
              </div>
            </div>
            <div class="modal-footer">
              <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
              <button type="submit" class="btn btn-primary" name="add_invoice" value="1">Add Invoice</button>
            </div>
          </form>
        </div>
      </div>
    </div>
    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.5.2/dist/js/bootstrap.bundle.min.js"></script>
    <script>
    $(function() {
        var sidebar = $('#adminSidebar');
        var overlay = $('#sidebarOverlay');
        sidebar.on('show.bs.collapse', function() {
            if (window.innerWidth < 768) overlay.show();
        });
        sidebar.on('hide.bs.collapse', function() {
            overlay.hide();
        });
        overlay.on('click', function() {
            sidebar.collapse('hide');
        });
        $(window).on('resize', function() {
            if (window.innerWidth >= 768) overlay.hide();
        });
    });
    </script>
</body>
</html>
