<?php
require_once '../../config/config.php';

// Check if user is logged in and is admin
$user = new User();
if (!$user->isLoggedIn() || !$user->isAdmin()) {
    echo json_encode(['success' => false, 'error' => 'Unauthorized access']);
    exit;
}

// Get POST data
$ticketId = isset($_POST['ticket_id']) ? intval($_POST['ticket_id']) : 0;
$status = isset($_POST['status']) ? $_POST['status'] : '';

// Validate input
if (!$ticketId || !$status) {
    echo json_encode(['success' => false, 'error' => 'Invalid input']);
    exit;
}

// Validate status
$validStatuses = ['created', 'active', 'in_process', 'closed', 'inactive', 'deleted'];
if (!in_array($status, $validStatuses)) {
    echo json_encode(['success' => false, 'error' => 'Invalid status']);
    exit;
}

// Update ticket status
$db = Database::getInstance();
$query = "UPDATE support_tickets SET status = ? WHERE id = ?";
$stmt = $db->prepare($query);
$stmt->bind_param('si', $status, $ticketId);

if ($stmt->execute()) {
    echo json_encode(['success' => true]);
} else {
    echo json_encode(['success' => false, 'error' => 'Failed to update ticket status']);
} 