<?php
$host = 'localhost';
$username = 'root';
$password = '';
$database = 'zeal_db';

try {
    // Connect without database selection first
    $mysqli = new mysqli($host, $username, $password);

    if ($mysqli->connect_error) {
        throw new Exception("Connection failed: " . $mysqli->connect_error);
    }

    // Create database if it doesn't exist
    if (!$mysqli->query("CREATE DATABASE IF NOT EXISTS $database")) {
        throw new Exception("Failed to create database: " . $mysqli->error);
    }

    // Select the database
    if (!$mysqli->select_db($database)) {
        throw new Exception("Failed to select database: " . $mysqli->error);
    }

    // Create users table if it doesn't exist
    $createUsersSQL = "CREATE TABLE IF NOT EXISTS users (
        id INT PRIMARY KEY AUTO_INCREMENT,
        username VARCHAR(10) UNIQUE NOT NULL,
        full_name VARCHAR(100) NOT NULL,
        email VARCHAR(100) NOT NULL,
        phone VARCHAR(15) NOT NULL,
        password VARCHAR(255) NOT NULL,
        role ENUM('admin', 'user') DEFAULT 'user',
        status ENUM('active', 'inactive') DEFAULT 'inactive',
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
    )";
    
    if (!$mysqli->query($createUsersSQL)) {
        throw new Exception("Failed to create users table: " . $mysqli->error);
    }

    // Create pins table if it doesn't exist
    $createPinsSQL = "CREATE TABLE IF NOT EXISTS pins (
        id INT PRIMARY KEY AUTO_INCREMENT,
        pin_number VARCHAR(10) UNIQUE NOT NULL,
        batch_id VARCHAR(20) NOT NULL,
        created_by INT NOT NULL,
        current_owner INT NOT NULL,
        status ENUM('created', 'transferred', 'activated') DEFAULT 'created',
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        activated_at TIMESTAMP NULL,
        FOREIGN KEY (created_by) REFERENCES users(id),
        FOREIGN KEY (current_owner) REFERENCES users(id)
    )";
    
    if (!$mysqli->query($createPinsSQL)) {
        throw new Exception("Failed to create pins table: " . $mysqli->error);
    }

    // Update pins table to include 'expired' status
    $sql = "ALTER TABLE pins MODIFY COLUMN status ENUM('created', 'transferred', 'activated', 'expired') DEFAULT 'created'";
    if ($mysqli->query($sql)) {
        echo "PIN table schema updated successfully\n";
    } else {
        echo "Failed to update PIN table schema: " . $mysqli->error . "\n";
    }

    $mysqli->close();
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
} 