<?php
// Connect without selecting a database
$mysqli = new mysqli('localhost', 'root', '');

if ($mysqli->connect_error) {
    die("Connection failed: " . $mysqli->connect_error . "\n");
}

// Create database if not exists
$sql = "CREATE DATABASE IF NOT EXISTS zeal_webapp CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci";
if ($mysqli->query($sql)) {
    echo "Database 'zeal_webapp' created or already exists.\n";
} else {
    die("Error creating database: " . $mysqli->error . "\n");
}

// Select the database
$mysqli->select_db('zeal_webapp');

// Create pins table if not exists
$sql = "CREATE TABLE IF NOT EXISTS pins (
    id INT PRIMARY KEY AUTO_INCREMENT,
    pin_number VARCHAR(10) UNIQUE NOT NULL,
    batch_id VARCHAR(20) NOT NULL,
    created_by INT NOT NULL,
    current_owner INT NOT NULL,
    status ENUM('created', 'transferred', 'activated', 'expired') DEFAULT 'created',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    activated_at TIMESTAMP NULL,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (created_by) REFERENCES users(id),
    FOREIGN KEY (current_owner) REFERENCES users(id)
)";

if ($mysqli->query($sql)) {
    echo "Table 'pins' created or already exists.\n";
} else {
    die("Error creating pins table: " . $mysqli->error . "\n");
}

// Create pin_transfers table if not exists
$sql = "CREATE TABLE IF NOT EXISTS pin_transfers (
    id INT PRIMARY KEY AUTO_INCREMENT,
    pin_id INT NOT NULL,
    from_user INT NOT NULL,
    to_user INT NOT NULL,
    transfer_date TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (pin_id) REFERENCES pins(id),
    FOREIGN KEY (from_user) REFERENCES users(id),
    FOREIGN KEY (to_user) REFERENCES users(id)
)";

if ($mysqli->query($sql)) {
    echo "Table 'pin_transfers' created or already exists.\n";
} else {
    die("Error creating pin_transfers table: " . $mysqli->error . "\n");
}

$mysqli->close();
echo "Database setup completed successfully!\n"; 