<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once __DIR__ . '/../../config/config.php';

try {
    echo "Attempting to connect to database...\n";
    $db = Database::getInstance();
    echo "Database connection successful.\n";
    
    // Check if admin user exists
    echo "Checking for existing admin user...\n";
    $checkQuery = "SELECT id FROM users WHERE role = 'admin' LIMIT 1";
    $result = $db->getConnection()->query($checkQuery);
    
    if (!$result) {
        throw new Exception("Error checking for admin user: " . $db->getConnection()->error);
    }
    
    if ($result->num_rows === 0) {
        echo "No admin user found. Creating new admin user...\n";
        
        // Create admin user
        $username = 'ZELADMIN01';
        $password = password_hash('admin123', PASSWORD_DEFAULT);
        $insertQuery = "INSERT INTO users (username, full_name, email, phone, password, role, status) 
                       VALUES (?, 'Admin User', 'admin@zeal.com', '1234567890', ?, 'admin', 'active')";
        
        $stmt = $db->getConnection()->prepare($insertQuery);
        if (!$stmt) {
            throw new Exception("Failed to prepare statement: " . $db->getConnection()->error);
        }
        
        $stmt->bind_param("ss", $username, $password);
        
        if ($stmt->execute()) {
            echo "Admin user created successfully!\n";
            echo "Username: {$username}\n";
            echo "Password: admin123\n";
        } else {
            throw new Exception("Failed to create admin user: " . $stmt->error);
        }
    } else {
        echo "Admin user already exists.\n";
    }
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
    echo "Stack trace:\n" . $e->getTraceAsString() . "\n";
} 