<?php
require_once '../../config/config.php';

// Check if user is logged in and is admin
$user = new User();
if (!$user->isLoggedIn() || !$user->isAdmin()) {
    echo json_encode(['success' => false, 'error' => 'Unauthorized access']);
    exit;
}

// Get POST data
$ticketId = isset($_POST['ticket_id']) ? intval($_POST['ticket_id']) : 0;
$message = isset($_POST['message']) ? trim($_POST['message']) : '';

// Validate input
if (!$ticketId || !$message) {
    echo json_encode(['success' => false, 'error' => 'Invalid input']);
    exit;
}

// Get current user ID
$userId = $user->getId();

// Add reply
$db = Database::getInstance();
$query = "INSERT INTO ticket_messages (ticket_id, sender_id, message) VALUES (?, ?, ?)";
$stmt = $db->prepare($query);
$stmt->bind_param('iis', $ticketId, $userId, $message);

if ($stmt->execute()) {
    // Update ticket status to in_process if it's not already closed
    $query = "UPDATE support_tickets SET status = 'in_process' WHERE id = ? AND status != 'closed'";
    $stmt = $db->prepare($query);
    $stmt->bind_param('i', $ticketId);
    $stmt->execute();

    echo json_encode(['success' => true]);
} else {
    echo json_encode(['success' => false, 'error' => 'Failed to add reply']);
} 