<?php
require_once '../../config/config.php';

// Check if user is logged in and is admin
$user = new User();
if (!$user->isLoggedIn() || !$user->isAdmin()) {
    http_response_code(403);
    echo json_encode(['error' => 'Unauthorized access']);
    exit;
}

// Check if it's a POST request
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['error' => 'Method not allowed']);
    exit;
}

// Get and validate input
$full_name = trim($_POST['full_name'] ?? '');
$email = filter_var(trim($_POST['email'] ?? ''), FILTER_SANITIZE_EMAIL);
$phone = trim($_POST['phone'] ?? '');
$password = trim($_POST['password'] ?? '');

$errors = [];

// Validate required fields
if (empty($full_name)) $errors[] = "Full name is required";
if (empty($email)) $errors[] = "Email is required";
if (!filter_var($email, FILTER_VALIDATE_EMAIL)) $errors[] = "Invalid email format";
if (empty($phone)) $errors[] = "Phone number is required";
if (empty($password)) $errors[] = "Password is required";
if (strlen($password) < 8) $errors[] = "Password must be at least 8 characters long";

if (!empty($errors)) {
    http_response_code(400);
    echo json_encode(['errors' => $errors]);
    exit;
}

try {
    $db = Database::getInstance();
    $db->getConnection()->begin_transaction();

    // Generate username (Format: ZEL25001A)
    $countQuery = "SELECT COUNT(*) as count FROM users";
    $result = $db->getConnection()->query($countQuery);
    $count = $result->fetch_assoc()['count'];
    $number = 25001 + $count;
    $username = "ZEL" . $number . "A";

    // Hash password
    $hashed_password = password_hash($password, PASSWORD_DEFAULT);

    // Insert new user
    $insertQuery = "INSERT INTO users (username, full_name, email, phone, password, role, status) 
                    VALUES (?, ?, ?, ?, ?, 'user', 'active')";
    $stmt = $db->getConnection()->prepare($insertQuery);
    $stmt->bind_param("sssss", $username, $full_name, $email, $phone, $hashed_password);
    $stmt->execute();
    
    $user_id = $db->getConnection()->insert_id;

    // Create empty profile
    $insertProfile = "INSERT INTO user_profiles (user_id, kyc_status) VALUES (?, 'pending')";
    $stmt = $db->getConnection()->prepare($insertProfile);
    $stmt->bind_param("i", $user_id);
    $stmt->execute();

    $db->getConnection()->commit();

    echo json_encode([
        'success' => true,
        'message' => 'Customer created successfully',
        'username' => $username
    ]);

} catch (Exception $e) {
    $db->getConnection()->rollback();
    http_response_code(500);
    echo json_encode(['error' => 'Failed to create customer: ' . $e->getMessage()]);
} 